    // ConnectionListener.h: interface for the CConnectionListener class.
    //
    //////////////////////////////////////////////////////////////////////
    
  #ifndef __CONNECTIONLISTENER__
  #define __CONNECTIONLISTENER__
  
// Platform specific definitions
#include "../Base/platform.h"

#ifdef linux
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
#endif //linux

#ifdef __SCO__
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
#endif // __SCO__

#ifdef __HPUX__
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
#endif // __HPUX__

#include "../../Include/Base/Thread.h"

#ifdef PASS_SSL
    #include <openssl/ssl.h>
#endif //PASS_SSL
    
    class CMessageStack;
    class CConnection;
    class CConnectionSocket;
    class CConnectionManager;
    
    class CConnectionListener : public CThread
    {
    public:
    	CConnectionListener();
    	virtual ~CConnectionListener();
    
    	virtual void Tick (void);
    
    	void SetPort (unsigned short port);
    	void SetStack (CMessageStack *aStack);
    	void SetConnection (CConnection *aConnection);
    	void SetSessionObjectName (char *name);
    	void SetConnectionManager (CConnectionManager *manager);
    
    	BOOL Initialize (void);
    	BOOL Close (void);
    
#ifdef PASS_SSL
    	void SetSecuredConnection (BOOL flag);
    	void SetCertificateFile (char *file);
    	void SetPrivateKeyFile (char *file);
#endif //PASS_SSL
    
    protected:
    	BOOL WaitConnection (void);

	public :
    	CConnectionManager *m_ConnectionManager;
    
    private:
    
    	unsigned short m_Port;
	  	int m_Listenfd;
	  	int m_NewConnFd;
    	struct sockaddr_in m_Serveraddr;
    	struct sockaddr_in m_newConnAddr;
    
#ifdef _WIN32
    	HANDLE m_hCloseEvent;
    	HANDLE m_hThread;
#endif //_WIN32
    
    	CConnectionSocket *m_Socket;
    
    	CMessageStack *m_ReceiveStack;
    	CConnection *m_ParentConnection;
    
    	char *m_SessionName;
    
#ifdef PASS_SSL
    	BOOL m_bSecuredConnection;
    	SSL_CTX* m_SSLctx;
    	SSL*     m_SSLssl;
    	SSL_METHOD *m_SSLmeth;
    	char *m_szCertificateFile;
    	char *m_szPrivateKeyFile;
#endif //PASS_SSL
    };
    
#endif // __CONNECTIONLISTENER__
