// Connection_Local.h: interface for the CConnection_Local class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __CONNECTION_LOCAL__
#define __CONNECTION_LOCAL__

// Platform specific definitions
#include "../Base/platform.h"

#include "../Comm/Connection.h"

class CMessageStack;
class CServerSession;
class CMessage;
class CStringToObjectCollection;

class CConnection_Local : public CConnection  
{
public:
	CConnection_Local();
	virtual ~CConnection_Local();

	BOOL Open (void);
	BOOL Close (void);

    CMessage *GetMessageForID (unsigned long messageID);
    CMessage *WaitMessageForID (unsigned long messageID);

	BOOL SetConnectionParam (CStringToObjectCollection *param);

	unsigned long SendMessage (CMessage *);

protected:
	CMessage *_GetMessageForID (unsigned long messageID);

protected:

	CMessageStack *m_SendStack;
	CMessageStack *m_ReceiveStack;
	CServerSession *m_Session;

	char m_szSessionObjectName[256];
	unsigned long m_ulMessageIDCounter;
	BOOL m_bConnectionOpened;
	unsigned long m_ulWaitMessageTimeOut;

	PASS_SYNCH lock;
};

#endif // __CONNECTION_LOCAL__
