    // GenericMessage.h: interface for the CGenericMessage class.
    //
    //////////////////////////////////////////////////////////////////////
    
#ifndef __MESSAGEGENERIC__
#define __MESSAGEGENERIC__

// Platform specific definitions
#include "../Base/platform.h"

#include "../../Include/Comm/Message.h"
    
    class CStringToObjectCollection;
    
    class CGenericMessage : public CMessage  
    {
    public:
    	CGenericMessage();
    	CGenericMessage(char *messageName);
    	virtual ~CGenericMessage();
    
    	void AddValueForKey (char *key, char *value);
    	void AddValueForKey (char *key, unsigned long value);
    	void AddValueForKey (char *key, BYTE *value, unsigned long valueLength);
    
    	BOOL GetValueForKey (char *key, char *value, unsigned long valueLength);
    	BOOL GetValueForKey (char *key, unsigned long *value);
    	BOOL GetValueForKey (char *key, BYTE *value, unsigned long valueLength);
    	unsigned long GetLengthForKey (char *key);
    
    	void AddValueForKeyInList (char *key, char *value, char *list);
    	void AddValueForKeyInList (char *key, unsigned long value, char *list);
    	void AddValueForKeyInList (char *key, BYTE *value, unsigned long valueLength, char *list);
    
    	BOOL GetValueForKeyInList (char *key, char *value, unsigned long valueLength, char *list);
    	BOOL GetValueForKeyInList (char *key, unsigned long *value, char *list);
    	BOOL GetValueForKeyInList (char *key, BYTE *value, unsigned long valueLength, char *list);
    	unsigned long GetLengthForKeyInList (char *key, char *list);

		CStringToObjectCollection *GetValues (void);
		CStringToObjectCollection *GetValuesInList (char *list);

    	BOOL Serialize (void);
    	BOOL UnSerialize (struct SerializedObject* anObject);
    	virtual CObject *Clone (void);
		virtual CObject *Copy (void);
    
    protected:
    
    	CStringToObjectCollection *m_Values;
    	CStringToObjectCollection *m_Lists;
    };
    
#endif //__MESSAGEGENERIC__
