    // LongToObjectCollection.cpp: implementation of the CLongToObjectCollection class.  
    //  
    //////////////////////////////////////////////////////////////////////  
      
  #include <stddef.h>  
  #include <string.h>  
  
  #include "../../Include/Base/LongToObjectCollection.h"  
       
    //////////////////////////////////////////////////////////////////////  
    // Construction/Destruction  
    //////////////////////////////////////////////////////////////////////  
      
  CLongToObjectCollection::CLongToObjectCollection() : CObject ("LongToObjectCollection","Collection")  
    {  
  	m_pPositionArray = (void **)new ULONG32 [101]; // one more to check end on list  
  	memset (m_pPositionArray,0,101 * sizeof(ULONG32)); // Init position array  
    	m_ul32MaxObject = 100;  
    	m_ul32ObjectCount = 0;  
  	m_pCollectionBottom = NULL;  
  	m_pCollectionTop = NULL;  
    }  
      
    CLongToObjectCollection::~CLongToObjectCollection()  
    {  
    	delete m_pPositionArray;  
      
    	// Delete all elements  
      
  	__LongToObjectCollectionElement *element = NULL;  
  	__LongToObjectCollectionElement *elementTemp = NULL;  
      
    	if (m_pCollectionTop != NULL)  
    	{  
    		element = m_pCollectionTop;  
      
    		while (element != NULL)  
    		{  
    			elementTemp = element->next;  
    			delete element;  
    			element = elementTemp;  
    		}  
    	}  
    }  
      
    void CLongToObjectCollection::Add (long key, CObject *object)  
    {  
    	BOOL foundKey = FALSE;  
      
    	// First check if the key already exist  
      
  	__LongToObjectCollectionElement *elementCheck = NULL;  
      
    	if (m_pCollectionTop != NULL)  
    	{  
    		elementCheck = m_pCollectionTop;  
      
    		while (foundKey == FALSE && elementCheck != NULL)  
    		{  
    			if (elementCheck->key == key)  
    			{  
    				// Found double  
    				foundKey = TRUE;  
    			}  
    			else  
    			{  
    				elementCheck = elementCheck->next;  
    			}  
    		}  
    	}  
      
    	if (foundKey == TRUE)  
    	{  
    		// Overwrite previous Object Reference  
    		elementCheck->object = object;  
    	}  
    	else  
    	{  
    		// New object to collection  
      
    		__LongToObjectCollectionElement *tempElement = new __LongToObjectCollectionElement;  
    		tempElement->object = object;  
    		tempElement->next = NULL;  
      
    		if (m_pCollectionTop == NULL)  
    		{  
    			m_pCollectionBottom = tempElement;  
    			m_pCollectionTop = tempElement;  
    		}  
    		else  
    		{  
    			m_pCollectionBottom->next = tempElement;  
    			m_pCollectionBottom = tempElement;  
    		}  
      
    		// Assign key  
      
    		tempElement->key = key;  
      
    		// Set position  
      
    		tempElement->position = m_ul32ObjectCount;  
      
    		// Set element pointer in position array  
      
    		if (m_ul32ObjectCount >= m_ul32MaxObject)  
    		{  
    			// Expand position array  
    			m_ul32MaxObject += 100;  
  			void **tempPositionArray = (void **) new ULONG32[(m_ul32MaxObject + 1)*sizeof(ULONG32)];  
  			memset (tempPositionArray,0,(m_ul32MaxObject + 1)*sizeof(ULONG32));  
    			memcpy (tempPositionArray,m_pPositionArray,(m_ul32MaxObject - 100)*sizeof(ULONG32));  
    			delete m_pPositionArray;  
    			m_pPositionArray = tempPositionArray;  
    		}  
      
    		m_pPositionArray[m_ul32ObjectCount] = tempElement;  
      
    		m_ul32ObjectCount++;  
    	}  
    }  
      
    ULONG32 CLongToObjectCollection::GetCount (void)  
    {  
    	return m_ul32ObjectCount;  
    }  
      
    BOOL CLongToObjectCollection::IsEmpty (void)  
    {  
    	if (m_ul32ObjectCount == 0)  
    	{  
    		return FALSE;  
    	}  
      
    	return TRUE;  
    }  
      
    CObject *CLongToObjectCollection::Lookup (long key)  
    {  
    	BOOL foundKey = FALSE;  
      
    	// Search the key  
      
  	__LongToObjectCollectionElement *elementCheck = NULL;  
      
    	if (m_pCollectionTop != NULL)  
    	{  
    		elementCheck = m_pCollectionTop;  
      
    		while (foundKey == FALSE && elementCheck != NULL)  
    		{  
    			if (elementCheck->key == key)  
    			{  
    				// Found double  
    				foundKey = TRUE;  
    			}  
    			else  
    			{  
    				elementCheck = elementCheck->next;  
    			}  
    		}  
      
    	}  
      
    	if (foundKey == TRUE)  
    	{  
    		return elementCheck->object;  
    	}  
      
  	return NULL;  
  }  
    
  BOOL CLongToObjectCollection::Remove (long key)  
  {  
  	// Find the key  
  	BOOL foundKey = FALSE;  
    
  	__LongToObjectCollectionElement *elementCheck = NULL;  
  	__LongToObjectCollectionElement *previous = NULL;  
    
  	if (m_pCollectionTop != NULL)  
  	{  
  		elementCheck = m_pCollectionTop;  
    
  		while (foundKey == FALSE && elementCheck != NULL)  
  		{			  
  			if (elementCheck->key==key)  
  			{  
  				// Found double  
  				foundKey = TRUE;  
  			}  
  			else  
  			{  
    				previous = elementCheck;  
    				elementCheck = elementCheck->next;  
    			}	  
    		}  
    	}  
      
    	if (foundKey == FALSE)  
    	{  
    		// Key not found return FALSE  
    		return FALSE;  
    	}  
      
    	// Key found, now get its position and remove it from the list  
    	if (previous == NULL && elementCheck->next == NULL)  
    	{  
    		// This was the only record in the list  
    		// Empty the collection  
    		m_pCollectionBottom = NULL;  
    		m_pCollectionTop = NULL;  
      
    		// Reset object count  
    		m_ul32ObjectCount = 0;  
      
    		// Clean position array  
    		memset (m_pPositionArray,0,m_ul32MaxObject * sizeof (void *));  
      
    		delete elementCheck;  
    	}  
    	else if (previous == NULL && elementCheck->next != NULL)	  
    	{  
    		// the key was the first in the list  
    		// Set new Collection Top  
    		m_pCollectionTop = elementCheck->next;  
    	  
    		// Update position array and change position in record  
      
    		m_ul32ObjectCount--;  
      
    		unsigned long counter = 0;  
    		__LongToObjectCollectionElement *element = m_pCollectionTop;  
      
    		// Clean up position array before re-numbering  
    		memset (m_pPositionArray,0,m_ul32MaxObject * sizeof (void *));  
      
    		while (element != NULL)  
    		{  
    			m_pPositionArray[counter] = element;  
    			element->position = counter;  
      
    			counter++;  
    			element = element->next;  
    		}  
      
    		delete elementCheck;  
    	}  
    	else if (previous != NULL && elementCheck->next == NULL)  
    	{  
    		// Last record  
      
    		// Set collection bottom  
    		m_pCollectionBottom = previous;  
    		previous->next = NULL;  
      
    		// Update object count  
    		m_ul32ObjectCount--;  
      
    		// Set position array to 0  
    		m_pPositionArray[elementCheck->position] = 0;  
      
    		// delete element  
    		delete elementCheck;  
    	}  
    	else if (previous != NULL && elementCheck->next != NULL)  
    	{  
    		// somewhere in the list  
      
    		// Link previous with next record  
    		previous->next = elementCheck->next;  
      
    		// Update position array and change position in record  
      
    		m_ul32ObjectCount--;  
      
    		unsigned long counter = previous->position + 1;  
    		__LongToObjectCollectionElement *element = elementCheck->next;  
      
    		// Clean up position array after previous record  
    		memset (m_pPositionArray + previous->position + 1,0,(m_ul32MaxObject - elementCheck->position) * sizeof (void *));
      
    		while (element != NULL)  
    		{  
    			m_pPositionArray[counter] = element;  
    			element->position = counter;  
      
    			counter++;  
    			element = element->next;  
    		}  
      
    		delete elementCheck;  
    	}  
      
    	return TRUE;  
    }  
      
    BOOL CLongToObjectCollection::Remove (CObject *object)  
    {  
    	if (object == NULL)  
    	{  
    		return FALSE;  
    	}  
      
    	// Find the key  
    	BOOL foundKey = FALSE;  
      
    	__LongToObjectCollectionElement *elementCheck = NULL;  
    	__LongToObjectCollectionElement *previous = NULL;  
      
    	if (m_pCollectionTop != NULL)  
    	{  
    		elementCheck = m_pCollectionTop;  
      
    		while (foundKey == FALSE && elementCheck != NULL)  
    		{  
    			if (elementCheck->object != NULL)  
    			{  
    				if (elementCheck->object == object)  
    				{  
    					// Found double  
    					foundKey = TRUE;  
    				}  
    				else  
    				{  
    					previous = elementCheck;  
    					elementCheck = elementCheck->next;  
    				}  
    			}  
    		}  
    	}  
      
    	if (foundKey == FALSE)  
    	{  
    		// Key not found return FALSE  
    		return FALSE;  
    	}  
      
    	// Key found, now get its position and remove it from the list  
    	if (previous == NULL && elementCheck->next == NULL)  
    	{  
    		// This was the only record in the list  
    		// Empty the collection  
    		m_pCollectionBottom = NULL;  
    		m_pCollectionTop = NULL;  
      
    		// Reset object count  
    		m_ul32ObjectCount = 0;  
      
    		// Clean position array  
    		memset (m_pPositionArray,0,m_ul32MaxObject * sizeof (void *));  
      
    		delete elementCheck;  
    	}  
    	else if (previous == NULL && elementCheck->next != NULL)	  
    	{  
    		// the key was the first in the list  
    		// Set new Collection Top  
    		m_pCollectionTop = elementCheck->next;  
    	  
    		// Update position array and change position in record  
      
    		m_ul32ObjectCount--;  
      
    		unsigned long counter = 0;  
    		__LongToObjectCollectionElement *element = m_pCollectionTop;  
      
    		// Clean up position array before re-numbering  
    		memset (m_pPositionArray,0,m_ul32MaxObject * sizeof (void *));  
      
    		while (element != NULL)  
    		{  
    			m_pPositionArray[counter] = element;  
    			element->position = counter;  
      
    			counter++;  
    			element = element->next;  
    		}  
      
    		delete elementCheck;  
    	}  
    	else if (previous != NULL && elementCheck->next == NULL)  
    	{  
    		// Last record  
      
    		// Set collection bottom  
    		m_pCollectionBottom = previous;  
    		previous->next = NULL;  
      
    		// Update object count  
    		m_ul32ObjectCount--;  
      
    		// Set position array to 0  
    		m_pPositionArray[elementCheck->position] = 0;  
      
    		// delete element  
    		delete elementCheck;  
    	}  
    	else if (previous != NULL && elementCheck->next != NULL)  
    	{  
    		// somewhere in the list  
      
    		// Link previous with next record  
    		previous->next = elementCheck->next;  
      
    		// Update position array and change position in record  
      
    		m_ul32ObjectCount--;  
      
    		unsigned long counter = previous->position + 1;  
    		__LongToObjectCollectionElement *element = elementCheck->next;  
      
    		// Clean up position array after previous record  
    		memset (m_pPositionArray + previous->position + 1,0,((m_ul32MaxObject - previous->position) + 1) * sizeof (void *));  
      
    		while (element != NULL)  
    		{  
    			m_pPositionArray[counter] = element;  
    			element->position = counter;  
      
    			counter++;  
    			element = element->next;  
    		}  
    		delete elementCheck;  
    	}  
      
    	return TRUE;  
    }  
      
    BOOL CLongToObjectCollection::RemoveAll (void)  
    {  
    	// delete all keys and structure  
    	__LongToObjectCollectionElement *elementCheck = NULL;  
      
    	if (m_pCollectionTop != NULL)  
    	{  
    		elementCheck = m_pCollectionTop;  
      
    		while (elementCheck != NULL)  
    		{  
    			__LongToObjectCollectionElement *tmp = elementCheck;  
    			elementCheck = elementCheck->next;  
    			delete tmp;  
    		}  
    	}  
      
    	// Clean up position array  
    	memset (m_pPositionArray,0,m_ul32MaxObject * sizeof (void *));  
      
    	// Reset object count  
    	m_ul32ObjectCount = 0;  
      
    	// close list  
    	m_pCollectionTop = NULL;  
    	m_pCollectionBottom = NULL;  
      
    	return TRUE;  
    }  
      
    CObject *CLongToObjectCollection::GetFirst (  
    	ULONG32 *firstPosition)  
    {  
    	__LongToObjectCollectionElement *element = NULL;  
      
    	if (firstPosition == NULL)  
    	{  
    		return NULL;  
    	}  
      
    	if (m_ul32ObjectCount == 0)  
    	{  
    		*firstPosition = 0;  
    		return NULL;  
    	}  
      
    	if (m_pPositionArray[0] == 0)  
    	{  
    		*firstPosition = 0;  
    		return NULL;  
    	}  
      
    	element = (__LongToObjectCollectionElement *)m_pPositionArray[0];  
    	*firstPosition = 1;  
      
    	return element->object;  
    }  
      
    CObject *CLongToObjectCollection::GetFirst (  
    	ULONG32 *firstPosition, long *key)  
    {  
    	__LongToObjectCollectionElement *element = NULL;  
      
    	if (firstPosition == NULL)  
    	{  
    		return NULL;  
    	}  
      
    	if (m_ul32ObjectCount == 0)  
    	{  
    		*firstPosition = 0;  
    		return NULL;  
    	}  
      
    	if (m_pPositionArray[0] == 0)  
    	{  
    		*firstPosition = 0;  
    		return NULL;  
    	}  
      
    	element = (__LongToObjectCollectionElement *)m_pPositionArray[0];  
    	*firstPosition = 1;  

		*key = element->key;
      
    	return element->object;  
    }  
      
    CObject *CLongToObjectCollection::GetNext (  
    	ULONG32 *nextPosition)  
    {  
    	__LongToObjectCollectionElement *element = NULL;  
      
    	if (nextPosition == NULL)  
    	{   
    		return NULL;  
    	}  
      
    	if (m_ul32ObjectCount == 0)  
    	{  
    		*nextPosition = 0;  
    		return NULL;  
    	}  
      
    	if (m_pPositionArray[*nextPosition] == 0)  
    	{  
    		*nextPosition = 0;  
    		return NULL;  
    	}  
      
    	element = (__LongToObjectCollectionElement *)m_pPositionArray[*nextPosition];  
    	*nextPosition = *nextPosition + 1;  
      
    	return element->object;  
    }  

	    CObject *CLongToObjectCollection::GetNext (  
    	ULONG32 *nextPosition, long *key)  
    {  
    	__LongToObjectCollectionElement *element = NULL;  
      
    	if (nextPosition == NULL)  
    	{   
    		return NULL;  
    	}  
      
    	if (m_ul32ObjectCount == 0)  
    	{  
    		*nextPosition = 0;  
    		return NULL;  
    	}  
      
    	if (m_pPositionArray[*nextPosition] == 0)  
    	{  
    		*nextPosition = 0;  
    		return NULL;  
    	}  
      
    	element = (__LongToObjectCollectionElement *)m_pPositionArray[*nextPosition];  
    	*nextPosition = *nextPosition + 1; 
		
		*key = element->key;
      
    	return element->object;  
    }  
