    // MasterManager.cpp  
    //  
      
    #include "../../Include/Base/MasterManager.h"  
    #include "../../Include/Base/Manager.h"  
    #include "../../Include/Base/StringToObjectCollection.h"  
    #include <string.h>  
      
    // Implementation  
      
    CMasterManager *CMasterManager::m_instance = 0;  
      
    CMasterManager::CMasterManager() : CObject ("MasterManager","MasterManager")  
    {  
    	managerCollection = new CStringToObjectCollection;  
    }  
      
    CMasterManager::~CMasterManager()   
    {  
    	if (managerCollection)  
    	{  
             managerCollection->RemoveAll();
    		delete managerCollection;  
            managerCollection = NULL;
    	}  
    }  
      
    CMasterManager *CMasterManager::Instance (void)  
    {  
    	if (m_instance == 0)  
    	{  
    		m_instance = new CMasterManager;  
      
    	} 
		 
		return m_instance;  
    }  
      
    void CMasterManager::RegisterManager(CManager* aManager) 
    {  
    	if (aManager && managerCollection)  
    	{  
    		managerCollection->Add (aManager->GetName(), aManager);  
    	}  
    }  
      
    CManager* CMasterManager::GetManager (char *managerName) 
    {  
    	return (CManager *)managerCollection->Lookup (managerName);  
    }  
      
    void CMasterManager::CreateDescription (void)  
    {  
		unsigned long managerCount = managerCollection->GetCount(); 
 
		AddToDescription (this,"Number of managers registered : %ld",managerCount); 
 
		ULONG32 position; 
		char key[256]; 
 
		managerCount = 1; 
		CManager *manager = (CManager *)managerCollection->GetFirst (&position,key,sizeof(key)); 
 
		while (manager != NULL) 
		{ 
			AddToDescription (this,"Manager n : %ld name : %s",managerCount++,manager->GetName()); 			 
			manager = (CManager *)managerCollection->GetNext (&position,key,sizeof(key)); 
		} 
    }  

    void CMasterManager::RemoveAll()
    {
         if (managerCollection)  
    	{  
            managerCollection->RemoveAll();
    		delete managerCollection;
            managerCollection = NULL;
    	}
         m_instance = NULL;         
    }
