// ObjectStack.cpp: implementation of the CObjectStack class.  
//  
//////////////////////////////////////////////////////////////////////  
  
#include <stddef.h>  
  
#include "../../Include/Base/ObjectStack.h"  
  
//////////////////////////////////////////////////////////////////////  
// Construction/Destruction  
//////////////////////////////////////////////////////////////////////  
      
    CObjectStack::CObjectStack()  
    {  
    	m_StackTop = 0;  
    	m_StackBottom = 0;  
    	m_ulMessageCount = 0;  
	    PASS_INITLOCK (&lock);
    }  
      
    CObjectStack::~CObjectStack()  
    {  
      	PASS_DESTROYLOCK (&lock);
    	// Clean up the stack  
    	__ObjectStackElement *temp, *temp2;  
    	temp = m_StackTop;  
      
  	    while (temp != NULL)  
  	    {  
  		    if (temp->object != NULL)  
  		    {  
  			    temp->object->Release();  
  		    }  
    		temp2 = temp;  
    		temp = temp->next;  
    		delete temp2;  
    	}  
    }  
      
    void CObjectStack::PutObject (CObject *anObject)  
    {  
      	PASS_LOCK (&lock);
    	// New message to stack  
      
    	__ObjectStackElement *tempStack = new __ObjectStackElement;  
    	tempStack->object = anObject;  
      
    	if (m_StackTop == NULL)  
    	{  
    		tempStack->next = 0;  
    		m_StackBottom = tempStack;  
    	}  
    	else  
    	{  
    		tempStack->next = m_StackTop;  
    	}  
      
    	// New head  
      
    	m_StackTop = tempStack;  
      
    	m_ulMessageCount++;  
    	PASS_UNLOCK (&lock);  
    }  
      
    BOOL CObjectStack::IsObjectAvailable (void)  
    {  
      	PASS_LOCK (&lock);
    	if (m_StackTop == NULL)  
    	{  
		PASS_UNLOCK (&lock);
    		return FALSE;  
    	}  
      
      	PASS_UNLOCK (&lock);
    	return TRUE;  
    }  
      
    CObject *CObjectStack::GetObject (void)  
    {  
      	PASS_LOCK (&lock);
    	CObject *returnObject = 0;  
     
#ifdef PASS_EXCEPTION  
    	try  
#endif // PASS_EXCEPTION  
    	{  
      
    	// No message  
    	if (m_StackBottom == NULL || m_StackTop == NULL)  
    	{  
		    PASS_UNLOCK (&lock);
    		return 0;  
    	}  
      
    	// Last message  
    	if (m_StackTop == m_StackBottom)  
    	{  
    		CObject *temp = m_StackBottom->object;  
    		delete m_StackBottom;  
    		m_StackTop = 0;  
    		m_StackBottom = 0;  
    		m_ulMessageCount--;  
		    PASS_UNLOCK (&lock);
    		return temp;  
    	}  
      
    	// Two message left  
      
    	if (m_StackTop->next == m_StackBottom)  
    	{  
    		CObject *temp = m_StackTop->object;  
    		delete m_StackTop;  
    		m_StackTop = 0;  
    		m_StackTop = m_StackBottom;  
    		m_ulMessageCount--;  
  		    PASS_UNLOCK (&lock);
    		return temp;  
      
    	}  
      
    	// Remove a object at the top of the stack  
      
    	returnObject = m_StackTop->object;  
    	__ObjectStackElement *tempElement = m_StackTop->next;  
    	delete m_StackTop;  
    	m_StackTop = tempElement;  
      
    	m_ulMessageCount--;  
    	}  
#ifdef PASS_EXCEPTION  
    	catch (...)  
    	{  
		    PASS_UNLOCK (&lock);
    		return 0;  
    	}  
#endif // PASS_EXCEPTION  
      
	    PASS_UNLOCK (&lock);
    	return returnObject;  
    }  
      
    CObject *CObjectStack::PeekObject (void)  
    {  
	    PASS_LOCK (&lock); 
    	// No object  
    	if (m_StackBottom == NULL || m_StackTop == NULL)  
    	{  
		    PASS_UNLOCK (&lock);
    		return 0;  
    	}  
      
  	// Found the last - 1 object  
      
    	CObject *tempObject = m_StackTop->object;  
      
	    PASS_UNLOCK (&lock);
    	return tempObject;  
    }  
