// ConnectionListener.cpp: implementation of the CConnectionListener class. 
// 
////////////////////////////////////////////////////////////////////// 
         
#include "../../Include/Comm/ConnectionListener.h" 
#include "../../Include/Comm/ConnectionSocket.h" 
#include "../../Include/Comm/MessageStack.h" 
#include "../../Include/Comm/Connection.h" 
#include "../../Include/Comm/Connection_Dual.h" 
#include "../../Include/Comm/Connection_Mono.h" 
#include "../../Include/Comm/ServerSession.h" 
#include "../../Include/Comm/ServerSessionDefault.h" 
#include "../../Include/Base/ObjectManager.h" 
#include "../../Include/Base/MasterManager.h" 
#include "../../Include/Base/LoggerManager.h" 
#include "../../Include/Comm/ConnectionManager.h" 
         
#ifdef PASS_SSL 
#include <openssl/ssl.h> 
#endif //PASS_SSL 
 
#ifdef linux 
#include <stddef.h> 
#include <unistd.h> 
#include <string.h> 
#include <stdio.h> 
#include <stdlib.h> 
#endif //linux 
         
#ifdef __SCO__ 
#include <stddef.h> 
#include <unistd.h> 
#include <string.h> 
#include <stdio.h> 
#endif // __SCO__ 
         
#ifdef __HPUX__ 
#include <stddef.h> 
#include <unistd.h>
#include <string.h> 
#include <stdio.h> 
#endif // __HPUX__ 
         
 
////////////////////////////////////////////////////////////////////// 
// Construction/Destruction 
////////////////////////////////////////////////////////////////////// 
         
#ifdef PASS_SSL 
int callback_ssl(char *buf, int size, int rwflag,void *userdata) 
        { 
			if (userdata == NULL) 
			{ 
				// No user data 
				return -1; 
			} 
 
			CConnectionListener *listener = (CConnectionListener *)userdata; 
 
			if (listener == NULL) 
			{ 
				return -1; 
			} 
 
			CConnectionManager *manager = listener->m_ConnectionManager; 
 
			if (manager == NULL) 
			{ 
				return -1; 
			} 
 
        	strncpy (buf,manager->GetPrivateKeyPassword(),size); 
        	return strlen (manager->GetPrivateKeyPassword()); 
        } 
#endif //PASS_SSL 
         
        CConnectionListener::CConnectionListener() 
        { 
        	m_ReceiveStack = NULL; 
        	m_Socket = NULL; 
			m_SessionName = NULL;
        	m_ParentConnection = NULL; 
        	m_ConnectionManager = NULL; 
	  	m_Listenfd = 0;  
  		m_NewConnFd = 0; 
#ifdef PASS_SSL 
        	m_bSecuredConnection = FALSE; 
        	m_SSLctx = NULL; 
        	m_SSLssl = NULL; 
        	m_SSLmeth = NULL; 
        	m_szCertificateFile = NULL; 
        	m_szPrivateKeyFile = NULL; 
#endif //PASS_SSL 

        	SetSessionObjectName ("ServerSessionDefault");
        } 
         
        CConnectionListener::~CConnectionListener() 
        { 
#ifdef PASS_SSL 
  	if (m_bSecuredConnection == TRUE) 
  	{ 
  		if (m_SSLssl != NULL) 
  		{ 
  			SSL_shutdown (m_SSLssl); 
  			SSL_set_connect_state (m_SSLssl); 
  		} 
  	} 
#endif //PASS_SSL 
   
  	if (m_Listenfd != 0) 
  	{ 
  		shutdown (m_Listenfd,0x02); 
#ifdef _WIN32 
        	closesocket	(m_Listenfd); 
#endif // _WIN32 
#ifdef linux 
 		close (m_Listenfd); 
#endif //_linux 
#ifdef __SCO__ 
 		close (m_Listenfd); 
#endif // __SCO__ 
#ifdef __HPUX__ 
 		close (m_Listenfd); 
#endif // __HPUX__ 
 	} 
  	if (m_NewConnFd != 0) 
  	{ 
  		shutdown (m_NewConnFd,0x02); 
#ifdef _WIN32 
  		closesocket (m_NewConnFd); 
#endif // _WIN32 
#ifdef linux 
  		close (m_NewConnFd); 
#endif //_linux 
#ifdef __SCO__ 
  		close (m_NewConnFd); 
#endif // __SCO__ 
#ifdef __HPUX__ 
  		close (m_NewConnFd); 
#endif // __HPUX__ 
  	} 
         
        	// Close the connection list 
         
#ifdef PASS_SSL 
  	if (m_bSecuredConnection == TRUE) 
  	{ 
  		if (m_SSLssl != NULL) 
  		{ 
  			SSL_free (m_SSLssl); 
  			m_SSLssl = NULL; 
  		} 
  		if (m_SSLctx != NULL) 
  		{ 
  			SSL_CTX_free (m_SSLctx); 
  			m_SSLctx = NULL; 
  		} 
  	} 
#endif //PASS_SSL 
         
        	if (m_Socket != NULL) 
        	{ 
        		m_Socket->Kill(); 
        		delete m_Socket; 
        	}
            if(m_SessionName != NULL)
            {
                delete m_SessionName;
            }
        } 
         
        void CConnectionListener::Tick (void) 
        { 
        	CConnectionSocket *localSocket; 
         
        	if (WaitConnection()) 
        	{ 
				// If maximum number of connection is reached, close the socket 
				if (m_ParentConnection == NULL) 
				{ 
					// This is a server 
					// Get current number of connection and max number from manager 
					if (m_ConnectionManager != NULL) 
					{ 
						unsigned long maxConnection = m_ConnectionManager->GetMaxServerConnection(); 
						unsigned long connectionCount = m_ConnectionManager->GetConnectionCount(); 
 
						if (connectionCount >= maxConnection) 
						{ 
							// Reached maximum number of connection close socket 
 
							Trace (__FILE__,__LINE__,LOGMASK_COMM,"Reached maximum number of client connection, closing socket"); 
 
							if (m_NewConnFd != 0) 
							{ 
								shutdown (m_NewConnFd,0x02); 
#ifdef _WIN32 
								closesocket (m_NewConnFd); 
#endif // _WIN32 
#ifdef linux 
								close (m_NewConnFd); 
#endif //_linux 
#ifdef __SCO__ 
								close (m_NewConnFd); 
#endif // __SCO__ 
#ifdef __HPUX__ 
								close (m_NewConnFd); 
#endif // __HPUX__ 
							} 
 
							// End listen to new connection 
							return; 
						} 
					} 
				} 
 
 	 			Trace (__FILE__,__LINE__,LOGMASK_COMM,"New connection in ConnectionListener"); 
 
				// Verify session name 

				if (m_SessionName == NULL)
				{
					shutdown (m_NewConnFd,0x02); 
#ifdef _WIN32 
					closesocket (m_NewConnFd); 
#endif // _WIN32 
#ifdef linux 
					close (m_NewConnFd); 
#endif //_linux 
#ifdef __SCO__ 
					close (m_NewConnFd); 
#endif // __SCO__ 
#ifdef __HPUX__ 
					close (m_NewConnFd); 
#endif // __HPUX__ 

					Trace (__FILE__,__LINE__,LOGMASK_COMM,"Can't create new connection, no session object name defined");

					return;
				}

        		// Try to instanciate the session 
        		CObjectManager *manager = CObjectManager::Instance(); 
        		CServerSession *localSession = (CServerSession *)manager->CreateByNameAndType (m_SessionName,"ServerSession"); 

        		if (localSession == NULL) 
        		{ 
					shutdown (m_NewConnFd,0x02); 
#ifdef _WIN32 
					closesocket (m_NewConnFd); 
#endif // _WIN32 
#ifdef linux 
					close (m_NewConnFd); 
#endif //_linux 
#ifdef __SCO__ 
					close (m_NewConnFd); 
#endif // __SCO__ 
#ifdef __HPUX__ 
					close (m_NewConnFd); 
#endif // __HPUX__ 

					Trace (__FILE__,__LINE__,LOGMASK_COMM,"Can't create new connection, can't instantiate session object, please register a session object");

					return;
				}

        		// Now allocate new Socket to establish connection 
        		localSocket = new CConnectionSocket (m_NewConnFd,m_newConnAddr); 
#ifdef PASS_SSL 
  		if (m_bSecuredConnection == TRUE) 
  		{ 
        		localSocket->SetSecuredConnection (m_bSecuredConnection); 
        		localSocket->SetSSLSSL (m_SSLssl); 
         
  				Trace (__FILE__,__LINE__,LOGMASK_COMM,"Secured params set to new CConnectionSocket"); 
  		} 
#endif //PASS_SSL 
        		if (localSocket != NULL) 
        		{ 
        			// Start receiver 
        			localSocket->SetTickTime (2);		 
 
					// Get connection manager 
					CMasterManager *master = CMasterManager::Instance(); 
					CConnectionManager *manager = (CConnectionManager *)master->GetManager ("Connection"); 
 
					// DUAL CONNECTION 
					if (strcmp (manager->GetConnectionType(),"Dual") == 0) 
					{ 
        				// Is it a server listener or a connection listener ? 
        				if (m_ParentConnection == NULL) 
        				{ 
        					// Server listener, create a new CConnection object 
        					CConnection_Dual *newConnection = new CConnection_Dual; 
#ifdef PASS_SSL 
  							if (m_bSecuredConnection == TRUE) 
  							{ 
        							newConnection->SetCertificateFile (m_szCertificateFile); 
        							newConnection->SetPrivateKeyFile (m_szPrivateKeyFile); 
	  								newConnection->SetSecuredConnection (m_bSecuredConnection); 
  							} 
#endif //PASS_SSL 
        					newConnection->SetTickTime (2); 
        					newConnection->Start(); 
        					newConnection->m_bServerConnection = TRUE; 
        					newConnection->SetSocket (localSocket); 
        					CMessageStack *localReceiveStack = newConnection->GetReceiveStack(); 
        					localSocket->SetConnection (newConnection); 
        					// Create new stack 
        					localSocket->SetStack (localReceiveStack);	 
        					// Allocate new session object if needed 
        					if (m_SessionName != NULL) 
        					{ 
        						// Try to instanciate the session 
        						CObjectManager *manager = CObjectManager::Instance(); 
        						CServerSession *localSession = (CServerSession *)manager->CreateByNameAndType (m_SessionName,"ServerSession"); 
         
        						if (localSession != NULL) 
        						{ 
#ifdef PASS_EXCEPTION 
        							try 
#endif // PASS_EXCEPTION 
        							{ 
        								localSession->SetReceiveStack (localReceiveStack); 
 	   									localSession->SetConnection (newConnection); 
        								localSocket->SetServerSession (localSession); 
        								newConnection->SetServerSession (localSession); 
        								localSession->SetTickTime (2); 
        								localSession->Start (); 
        							} 
#ifdef PASS_EXCEPTION 
        							catch (...) 
        							{ 
        								// Error seems to be the wrong object; 
        								delete localSession; 
        								delete localSocket; 
        								delete localReceiveStack; 
        								localSocket = NULL; 
        								localReceiveStack = NULL; 
        							} 
#endif // PASS_EXCEPTION 
        						} 
        					} 
        					else 
        					{ 
        						// Allocate Default server session object 
        						CServerSession *defaultSession = new CServerSessionDefault; 
        						defaultSession->SetReceiveStack (localReceiveStack); 
 	   							defaultSession->SetConnection (newConnection); 
        						localSocket->SetServerSession (defaultSession); 
        						newConnection->SetServerSession (defaultSession); 
        						defaultSession->SetTickTime (2); 
        						defaultSession->Start(); 
        					} 
 
        					// Add this new connection to the connection list 
        					if (m_ConnectionManager != NULL) 
        					{ 
        						m_ConnectionManager->AddConnection (newConnection); 
        					} 
        				} 
        				else 
        				{ 
        					// Connection listener 
        					localSocket->SetConnection (m_ParentConnection); 
        					localSocket->SetStack (((CConnection_Dual *)m_ParentConnection)->GetReceiveStack()); 
        					((CConnection_Dual *)m_ParentConnection)->SetSocket (localSocket); 
        				} 
					} 
 
					// MONO CONNECTION 
					if (strcmp (manager->GetConnectionType(),"Mono") == 0) 
					{ 
						// Mono socket connection 
 
        				// Is it a server listener or a connection listener ? 
        				if (m_ParentConnection == NULL) 
        				{ 
        					// Server listener, create a new CConnection object 
        					CConnection_Mono *newConnection = new CConnection_Mono; 
#ifdef PASS_SSL 
  							if (m_bSecuredConnection == TRUE) 
  							{ 
        							newConnection->SetCertificateFile (m_szCertificateFile); 
        							newConnection->SetPrivateKeyFile (m_szPrivateKeyFile); 
  									newConnection->SetSecuredConnection (m_bSecuredConnection); 
  							} 
#endif //PASS_SSL 
        					newConnection->SetTickTime (2); 
        					newConnection->Start(); 
        					newConnection->m_bServerConnection = TRUE; 
        					newConnection->SetSocket (localSocket); 
        					localSocket->SetConnection (newConnection); 
 
							// Assign send and receive stack to the socket 
        					localSocket->SetReceiveStack (newConnection->GetReceiveStack());	 
        					localSocket->SetSendStack (newConnection->GetSendStack());	 
 
#ifdef PASS_EXCEPTION 
        					try 
#endif // PASS_EXCEPTION 
        					{ 
        						localSession->SetReceiveStack (newConnection->GetReceiveStack()); 
        						localSession->SetSendStack (newConnection->GetSendStack()); 
 	   							localSession->SetConnection (newConnection); 
        						localSocket->SetServerSession (localSession); 
        						newConnection->SetServerSession (localSession); 
        						localSession->SetTickTime (2); 
        						localSession->Start (); 
        					} 
#ifdef PASS_EXCEPTION 
        					catch (...) 
        					{ 
        						// Error seems to be the wrong object; 
								unsigned long timeout = 0;

								// Stop session
								localSession->Stop();

								while (localSession->CanBeDeleted() == FALSE && timeout < 600)
								{
									PASS_MILLISLEEP (100);
									timeout++;
								}

								if (timeout == 600)
								{
									localSession->Kill();
									Trace (__FILE__,__LINE__,LOGMASK_COMM,"Server session killed, this application can be unstable, please consider to restart it");
								}

        						delete localSession; 
								localSession = NULL;

        						delete localSocket; 
        						localSocket = NULL; 

								// Stop connection
								newConnection->Stop();

								while (newConnection->CanBeDeleted() == FALSE && timeout < 600)
								{
									PASS_MILLISLEEP (100);
									timeout++;
								}

								if (timeout == 600)
								{
									newConnection->Kill();
									Trace (__FILE__,__LINE__,LOGMASK_COMM,"Connection killed, this application can be unstable, please consider to restart it");
								}

								delete newConnection;
								newConnection = NULL;
        					} 
#endif // PASS_EXCEPTION 

        					// Add this new connection to the connection list 
        					if (m_ConnectionManager != NULL) 
        					{ 
        						m_ConnectionManager->AddConnection (newConnection); 
        					} 
						} 
					} 
         
        			if (localSocket != NULL) 
        			{ 
       					localSocket->Start(); 
 
  						Trace (__FILE__,__LINE__,LOGMASK_COMM,"New CConnectionSocket started"); 
        			} 
        		} 
        	} 
        	else 
        	{ 
#ifdef _WIN32 
        		SetEvent(m_hCloseEvent); 
#endif //_WIN32 
#ifdef linux 
 				pthread_mutex_lock (&m_InternalLock); 
  				m_CloseFlag = TRUE; 
  				pthread_mutex_unlock (&m_InternalLock); 
#endif // linux 
#ifdef __SCO__ 
 				mutex_lock (&m_InternalLock); 
  				m_CloseFlag = TRUE; 
  				mutex_unlock (&m_InternalLock); 
#endif // __SCO__ 
#ifdef __HPUX__ 
 				pthread_mutex_lock (&m_InternalLock); 
  				m_CloseFlag = TRUE; 
  				pthread_mutex_unlock (&m_InternalLock); 
#endif // __HPUX__ 
 
  				Trace (__FILE__,__LINE__,LOGMASK_COMM,"WaitConnection Failed");         
        	} 
        } 
         
        void CConnectionListener::SetPort (unsigned short port) 
        { 
        	m_Port = port; 
        } 
         
        void CConnectionListener::SetStack (CMessageStack *aStack) 
        { 
        	m_ReceiveStack = aStack; 
        } 
         
        void CConnectionListener::SetConnection (CConnection *aConnection) 
        { 
        	m_ParentConnection = aConnection; 
        } 
         
        BOOL CConnectionListener::WaitConnection (void) 
        { 
#ifdef _WIN32 
	       	int newConnLen; 
#endif //_WIN32 
#ifdef linux 
 	socklen_t newConnLen; 
#endif //linux 
#ifdef __SCO__ 
	size_t newConnLen; 
#endif //__SCO__ 
#ifdef __HPUX__ 
 	int newConnLen; 
#endif //__HPUX__ 
	 
        	newConnLen = sizeof (m_newConnAddr); 
         
        	m_NewConnFd = 0; 
        	m_NewConnFd = accept (m_Listenfd, (struct sockaddr *) &m_newConnAddr, &newConnLen); 
         
#ifdef PASS_SSL 
        	if (m_bSecuredConnection == TRUE && m_SSLctx != NULL) 
        	{ 
        		int err; 
         
        		m_SSLssl = SSL_new (m_SSLctx); 
        		SSL_set_fd (m_SSLssl, m_NewConnFd); 
        		err = SSL_accept (m_SSLssl); 
        		if (err == -1) 
        		{ 
        			// Error while accepting SSL connection 
        			return FALSE; 
        		} 
 
				/* Get client's certificate (note: beware of dynamic allocation) - opt */ 
 
				X509* client_cert; 
				char* strSubject; 
				char* strIssuer; 
 
				client_cert = SSL_get_peer_certificate (m_SSLssl); 
 
				if (client_cert != NULL) 
				{ 
					strSubject = X509_NAME_oneline (X509_get_subject_name (client_cert), 0, 0); 
					strIssuer = X509_NAME_oneline (X509_get_issuer_name  (client_cert), 0, 0); 
 
					Trace (__FILE__,__LINE__,LOGMASK_COMM,"Client certificate : \t subject: %s\t issuer: %s",strSubject,strIssuer); 
 
					free (strSubject); 
					free (strIssuer); 
 
					/* We could do all sorts of certificate verification stuff here before 
					deallocating the certificate. */ 
 
					X509_free (client_cert); 
				} 
				else 
				{ 
					Trace (__FILE__,__LINE__,LOGMASK_COMM,"Client does not have certificate."); 
				} 
        	} 
#endif //PASS_SSL 
 
			Trace (__FILE__,__LINE__,LOGMASK_COMM,"Listener accepting new connection"); 
 
        	if (m_NewConnFd == -1) 
        	{ 
        		return FALSE; 
        	} 
         
        	return TRUE; 
        } 
         
        BOOL CConnectionListener::Initialize (void) 
        { 
        	m_Listenfd = socket (AF_INET, SOCK_STREAM, 0); 
         
			Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"get socket %d",m_Listenfd); 
#ifdef _WIN32 
        	if (m_Listenfd == INVALID_SOCKET) 
#endif //_WIN32 
#ifdef linux 
	 	if (m_Listenfd == -1) 
#endif //linux 
#ifdef __SCO__ 
	 	if (m_Listenfd == -1) 
#endif // __SCO__ 
#ifdef __HPUX__ 
	 	if (m_Listenfd == -1) 
#endif // __HPUX__ 
        	{ 
        		return FALSE; 
        	} 
         
        	memset (&m_Serveraddr,0,sizeof(m_Serveraddr)); 
        	m_Serveraddr.sin_family = AF_INET; 
        	m_Serveraddr.sin_addr.s_addr = htonl(INADDR_ANY); 
        	m_Serveraddr.sin_port = htons(m_Port); 
         
			// Set socket option 
			int autorisation; 
			autorisation = 1; 
			setsockopt (m_Listenfd,SOL_SOCKET, SO_REUSEADDR, (char *)&autorisation,sizeof (int)); 
 
			Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"Try to bind socket"); 
#ifdef _WIN32 
        	if ((bind (m_Listenfd,(struct sockaddr *) &m_Serveraddr, sizeof (m_Serveraddr))) == SOCKET_ERROR) 
#endif //_WIN32 
#ifdef linux 
	  	if ((bind (m_Listenfd,(struct sockaddr *) &m_Serveraddr, sizeof (m_Serveraddr))) == -1) 
#endif //linux 
#ifdef __SCO__ 
	  	if ((bind (m_Listenfd,(struct sockaddr *) &m_Serveraddr, sizeof (m_Serveraddr))) == -1) 
#endif // __SCO__ 
#ifdef __HPUX__ 
	  	if ((bind (m_Listenfd,(struct sockaddr *) &m_Serveraddr, sizeof (m_Serveraddr))) == -1) 
#endif // __HPUX__ 
        	{ 
				Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"Failed to bind socket"); 
        		return FALSE; 
        	} 
         
			Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"Try to listen"); 
#ifdef _WIN32 
        	if ((listen (m_Listenfd, 1024)) == SOCKET_ERROR) 
#endif //_WIN32 
#ifdef linux 
	 	if ((listen (m_Listenfd, 1024)) == -1) 
#endif //linux 
#ifdef __SCO__ 
	 	if ((listen (m_Listenfd, 1024)) == -1) 
#endif // __SCO__ 
#ifdef __HPUX__ 
	 	if ((listen (m_Listenfd, 1024)) == -1) 
#endif // __HPUX__ 
        	{ 
				Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"Failed to listen"); 
        		return FALSE; 
        	} 
        	return TRUE; 
        } 
         
        BOOL CConnectionListener::Close (void) 
        { 
			Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"CConnectionListener Close"); 
#ifdef PASS_SSL 
 	     	if (m_bSecuredConnection == TRUE) 
  		{ 
  			if (m_SSLssl != NULL) 
      		{ 
      			SSL_shutdown(m_SSLssl); 
 				SSL_set_connect_state (m_SSLssl); 
 			} 
 		} 
#endif //PASS_SSL 
       
	  	if (m_Listenfd != 0) 
	  	{ 
	        	shutdown (m_Listenfd, 0x02); 
#ifdef _WIN32 
       		 	closesocket (m_Listenfd); 
#endif //_WIN32 
#ifdef linux 
 			close (m_Listenfd); 
#endif //linux 
#ifdef __SCO__ 
 			close (m_Listenfd); 
#endif // __SCO__ 
#ifdef __HPUX__ 
 			close (m_Listenfd); 
#endif // __HPUX__ 
 			m_Listenfd = 0; 
 		} 
  
	 	if (m_NewConnFd != 0) 
	 	{ 
	        	shutdown (m_NewConnFd, 0x02); 
#ifdef _WIN32 
       		 	closesocket (m_NewConnFd);         
#endif //_WIN32 
#ifdef linux 
	 			close (m_NewConnFd); 
#endif //linux 
#ifdef __SCO__ 
	 			close (m_NewConnFd); 
#endif // __SCO__ 
#ifdef __HPUX__ 
	 			close (m_NewConnFd); 
#endif // __HPUX__ 
 			m_NewConnFd = 0; 
 		} 
  
#ifdef PASS_SSL 
        	if (m_bSecuredConnection == TRUE) 
        	{ 
        		if (m_SSLssl != NULL) 
        		{ 
        			SSL_free (m_SSLssl); 
 	 				m_SSLssl = NULL; 
        		} 
        		if (m_SSLctx != NULL) 
        		{ 
        			SSL_CTX_free (m_SSLctx); 
	  				m_SSLctx = NULL; 
  				} 
  			} 
#endif //PASS_SSL 
 
	      	if (m_Socket != NULL) 
	      	{ 
	 		 	Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"Wait socket to Stop"); 
 	     		m_Socket->Stop(); 
 	     		while (m_Socket->CanBeDeleted() == FALSE) 
 	     		{ 
				PASS_MILLISLEEP (10);
      			} 
       
		 		Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"Socket stopped"); 
      			delete m_Socket; 
      			m_Socket = NULL; 
      		} 
 
			Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"all socket closed"); 
			Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"exiting CConnectionListner Close"); 
        	return TRUE; 
        } 
         
        void CConnectionListener::SetSessionObjectName (char *name) 
        { 
        	if (name != NULL) 
        	{ 
        		if (m_SessionName != NULL) 
        		{ 
        			delete [] m_SessionName; 
        		} 
        		m_SessionName = new char [(strlen (name)) + 1]; 
        		strcpy (m_SessionName,name); 
        	} 
        } 
         
#ifdef PASS_SSL 
        void CConnectionListener::SetSecuredConnection (BOOL flag) 
        { 
        	m_bSecuredConnection = flag; 
        	if (m_bSecuredConnection == TRUE) 
        	{ 
        		// Initialize SSL 
           
        		/* SSL preliminaries. We keep the certificate and key with the context. */ 
         
        		SSL_load_error_strings(); 
        		SSLeay_add_ssl_algorithms(); 
        		m_SSLmeth = SSLv2_server_method(); 
        		m_SSLctx = SSL_CTX_new (m_SSLmeth); 
         
        		SSL_CTX_set_default_passwd_cb (m_SSLctx,callback_ssl); 
				SSL_CTX_set_default_passwd_cb_userdata (m_SSLctx,(void *)this); 
         
        		if (!m_SSLctx) 
        		{ 
        			m_SSLctx = NULL; 
        		}  
        		else if (SSL_CTX_use_certificate_file(m_SSLctx, m_szCertificateFile, SSL_FILETYPE_PEM) <= 0) 
        		{ 
        			m_SSLctx = NULL; 
        		} 
        		else if (SSL_CTX_use_PrivateKey_file(m_SSLctx, m_szPrivateKeyFile, SSL_FILETYPE_PEM) == 0) 
        		{ 
        			m_SSLctx = NULL; 
        		} 
        		else if (!SSL_CTX_check_private_key(m_SSLctx)) 
        		{ 
        			m_SSLctx = NULL; 
        		} 
        	} 
        } 
         
        void CConnectionListener::SetCertificateFile (char *file) 
        { 
        	if (file != NULL) 
        	{ 
        		if (m_szCertificateFile != NULL) 
        		{ 
        			delete [] m_szCertificateFile; 
        		} 
        		m_szCertificateFile = new char [(strlen (file)) + 1]; 
        		strcpy (m_szCertificateFile,file); 
        	} 
        } 
         
        void CConnectionListener::SetPrivateKeyFile (char *file) 
        { 
        	if (file != NULL) 
        	{ 
        		if (m_szPrivateKeyFile != NULL) 
        		{ 
        			delete [] m_szPrivateKeyFile; 
        		} 
        		m_szPrivateKeyFile = new char [(strlen (file)) + 1]; 
        		strcpy (m_szPrivateKeyFile,file); 
        	} 
        } 
         
#endif //PASS_SSL 
 
        void CConnectionListener::SetConnectionManager (CConnectionManager *manager) 
        { 
        	m_ConnectionManager = manager; 
        } 
