// ConnectionSocket.cpp: implementation of the CConnectionSocket class. 
// 
////////////////////////////////////////////////////////////////////// 
 
#include "../../Include/Comm/ConnectionSocket.h" 
#include "../../Include/Comm/ConnectionSender.h" 
#include "../../Include/Comm/MessageStack.h" 
#include "../../Include/Comm/Connection.h" 
#include "../../Include/Comm/Connection_Dual.h" 
#include "../../Include/Comm/ServerSession.h" 
#include "../../Include/Base/ObjectManager.h" 
#include "../../Include/Base/LoggerManager.h" 
#include "../../Include/Comm/Message.h" 
#include "../../Include/Comm/DispatchMessage.h" 
#include "../../Include/Comm/ConnectionMessage_OpenBack.h" 
#include "../../Include/Comm/ConnectionMessage_Close.h" 
#include "../../Include/Comm/ConnectionMessage_Break.h" 
 
#ifdef _WIN32 
#include <io.h> 
#define SD_RECEIVE      0x00 
#define SD_SEND         0x01 
#define SD_BOTH         0x02 
#endif //_WIN32 
 
#ifdef linux 
#include <stddef.h> 
#include <string.h> 
#include <sys/time.h> 
#include <sys/types.h> 
#include <unistd.h> 
#include <stdio.h> 
#include <errno.h>
#ifndef MSG_DONTWAIT
    #define MSG_DONTWAIT 0
#endif 
#endif //linux 
 
#ifdef __SCO__ 
#include <stddef.h> 
#include <string.h> 
#include <sys/time.h> 
#include <sys/types.h> 
#include <unistd.h> 
#include <stdio.h> 
#endif // __SCO__ 
 
#ifdef __HPUX__ 
#include <stddef.h> 
#include <string.h> 
#include <sys/time.h> 
#include <sys/types.h> 
#include <unistd.h> 
#include <stdio.h> 
#endif // __HPUX__ 
 
#ifdef PASS_SSL 
extern int SSL_writen (SSL *sslfd,const void *vptr, int n); 
#endif // PASS_SSL 
         
 
////////////////////////////////////////////////////////////////////// 
// Construction/Destruction 
////////////////////////////////////////////////////////////////////// 

#ifdef PASS_SSL        
int SSL_readn (SSL* sslfd, void *vptr, size_t n) 
{ 
	int nleft; 
	int nread; 
	char *ptr; 
 
	ptr = (char *)vptr; 
	nleft = n; 
 
	while (nleft > 0) 
	{ 
		if ((nread = SSL_read (sslfd,ptr,nleft)) == -1) 
		{ 
			return -1; 
		} else if (nread == 0) 
		{ 
			break; 
		} 
 
		nleft -= nread; 
		ptr += nread; 
	} 
 
	return (n-nleft); 
} 
#endif // PASS_SSL 
       
CConnectionSocket::CConnectionSocket() : CThread ("ConnectionSocket") 
{ 
	m_NewConnFd = 0; 
	compt = 0; 
	m_bCloseFlag = FALSE; 
	memset (&m_NewConnAddr,0,sizeof (m_NewConnAddr)); 
	m_ParentConnection = NULL; 
	m_ServerSession = NULL; 
	m_bMessageReadError = FALSE; 
	m_bMessageReadOK = FALSE; 
	m_bSocketClosing = FALSE; 
	m_CurrentMessage = NULL; 
 
#ifdef PASS_SSL 
	m_bSecuredConnection = FALSE; 
	m_SSLssl = NULL; 
	m_szCertificateFile = NULL; 
#endif //PASS_SSL 
} 
         
CConnectionSocket::CConnectionSocket(int newConnFd, struct sockaddr_in newConnAddr) : CThread ("ConnectionSocket") 
{ 
	m_NewConnFd = newConnFd; 
	m_bCloseFlag = FALSE; 
	memcpy (&m_NewConnAddr, &newConnAddr, sizeof(newConnAddr)); 
	char bufferIP[16]; 
	memset (bufferIP,0,16); 
	strncpy (bufferIP,inet_ntoa (newConnAddr.sin_addr),15); 
 
	Trace (__FILE__,__LINE__,LOGMASK_COMM,"New Socket created with socket from peer IP : %s",bufferIP); 
 
	m_ParentConnection = NULL; 
	m_ServerSession = NULL; 
	m_bMessageReadError = FALSE; 
	m_bMessageReadOK = FALSE; 
	m_bSocketClosing = FALSE; 
	m_CurrentMessage = NULL; 
 
#ifdef PASS_SSL 
	m_bSecuredConnection = FALSE; 
	m_SSLssl = NULL; 
	m_szCertificateFile = NULL; 
#endif //PASS_SSL 
} 
         
CConnectionSocket::~CConnectionSocket() 
{ 
	if (m_NewConnFd != 0) 
	{ 
		Trace (__FILE__,__LINE__,LOGMASK_COMM,"Closing socket : %d",m_NewConnFd); 
 
#ifdef _WIN32 
			closesocket (m_NewConnFd); 
#endif //_WIN32 
#ifdef linux 
			close (m_NewConnFd); 
#endif //linux 
#ifdef __SCO__ 
			close (m_NewConnFd); 
#endif // __SCO__ 
#ifdef __HPUX__ 
			close (m_NewConnFd); 
#endif // __HPUX__ 
	} 
} 
 
struct sockaddr_in *CConnectionSocket::GetSockAddr(void)
{
    return &m_NewConnAddr;
}

void CConnectionSocket::PreRun (void) 
{ 
	Trace (__FILE__,__LINE__,LOGMASK_COMM,"PreRun"); 
} 
 
void CConnectionSocket::PostRun (void) 
{ 
	Trace (__FILE__,__LINE__,LOGMASK_COMM,"PostRun"); 
} 
         
void CConnectionSocket::Tick(void) 
{ 
	// DUAL CONNECTION 
	if (strcmp (m_ParentConnection->GetName (),"Dual") == 0) 
	{ 
		ReadMessageFromSocket (); 
 
		if (m_CurrentMessage != NULL) 
		{ 
			if (strcmp (m_CurrentMessage->GetName(),"ConnectionMessage_OpenBack") == 0) 
			{ 
				if (m_ParentConnection != NULL) 
				{ 
					// If openback was already sent, just stack the message 
					if (((CConnection_Dual *)m_ParentConnection)->m_bOpenBackSent == TRUE) 
					{ 
						m_ReceiveStack->PutMessage (m_CurrentMessage); 
					} 
					else 
					{ 
						// Now try to open the sender 
						CConnectionSender *localSender = new CConnectionSender; 
 
#ifdef PASS_SSL 
						if (m_bSecuredConnection == TRUE) 
						{ 
							Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"Use certificate : %s to open the connection back",((CConnection_Dual *)m_ParentConnection)->GetCertificateFile ()); 
							localSender->SetCertificateFile (((CConnection_Dual *)m_ParentConnection)->GetCertificateFile()); 
							localSender->SetSecuredConnection (m_bSecuredConnection); 
							Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"Set secured flag to new CConnectionSender"); 
						} 
#endif //PASS_SSL 
 
						CConnectionMessage_OpenBack *openBack = (CConnectionMessage_OpenBack *)m_CurrentMessage; 
						// Get remote ip from sock_addr structure 
 
#ifdef _WIN32 
						char bufferIP[16]; 
						memset (bufferIP,0,16); 
						if (inet_ntoa (m_NewConnAddr.sin_addr) != NULL) 
						{ 
							strncpy (bufferIP,inet_ntoa (m_NewConnAddr.sin_addr),15); 
							localSender->SetRemoteServerIP (bufferIP); 
						} 
						else 
						{ 
							localSender->SetRemoteServerIP (openBack->GetBackIP()); 
						} 
#endif //_WIN32 
 
#ifdef __SCO__ 
						char bufferIP[16]; 
						memset (bufferIP,0,16); 
						if (inet_ntoa (m_NewConnAddr.sin_addr) != NULL) 
						{ 
							strncpy (bufferIP,inet_ntoa (m_NewConnAddr.sin_addr),15); 
							localSender->SetRemoteServerIP (bufferIP); 
						} 
						else 
						{ 
							localSender->SetRemoteServerIP (openBack->GetBackIP()); 
						} 
#endif // __SCO__ 
 
#ifdef __HPUX__ 
						char bufferIP[16]; 
						memset (bufferIP,0,16); 
						if (inet_ntoa (m_NewConnAddr.sin_addr) != NULL) 
						{ 
							strncpy (bufferIP,inet_ntoa (m_NewConnAddr.sin_addr),15); 
							localSender->SetRemoteServerIP (bufferIP); 
						} 
						else 
						{ 
							localSender->SetRemoteServerIP (openBack->GetBackIP()); 
						} 
#endif // __HPUX__ 
 
						localSender->SetRemoteServerPort (openBack->GetBackPort()); 
 
#ifdef linux 
						localSender->SetClientSocket (m_NewConnFd); 
#endif //linux 
 
						// Try connect 
						Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"Try to connect back to the client with IP : %s and port : %d",openBack->GetBackIP(),openBack->GetBackPort()); 
						if (localSender->Init() == FALSE) 
						{ 
							// Can't open connection back to client 
							delete localSender; 
							localSender = NULL; 
							Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"Can't open back connection"); 
						} 
 
						if (localSender != NULL) 
						{ 
							// Connection open, set send stack 
							Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"Connection back opened"); 
							CMessageStack *sendStack = ((CConnection_Dual *)m_ParentConnection)->GetSendStack(); 
							localSender->SetStack (sendStack); 
							localSender->SetTickTime (2); 
							localSender->Start(); 
 
							// Check if acting as a Client or a Server 
							if (m_ServerSession != NULL) 
							{ 
								// Server 
								// Assign send stack to CServerSession 
								m_ServerSession->SetSendStack (sendStack); 
							} 
							if (m_ParentConnection != NULL) 
							{ 
								((CConnection_Dual *)m_ParentConnection)->SetSender (localSender); 
							} 
 
							// Send back the OpenBack message 
							Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"Send back the openback message"); 
							sendStack->PutMessage (openBack); 
						} 
					} 
				} 
			} 
			else if ((strcmp (m_CurrentMessage->GetName(),"ConnectionMessage_Close")) == 0) 
			{ 
				m_bCloseFlag = TRUE; 
 
				// Send the message back to sender 
				((CConnection_Dual *)m_ParentConnection)->SendMessage (m_CurrentMessage); 
				Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"CConnectionSocket get Closeevent"); 
 
				// The message is sent back to sender 
				// The CloseFlag should be set (in sender) 
				// Now this is the job of Connection to close and stop 
				// Sender and Socket 
			} 
			else if ((strcmp (m_CurrentMessage->GetName(),"ConnectionMessage_SetName")) == 0) 
			{ 
			} 
			else 
			{ 
				m_ReceiveStack->PutMessage (m_CurrentMessage); 
			} 
		} 
 
		compt++; 
	} 
 
	// MONO CONNECTION 
	if (strcmp (m_ParentConnection->GetName(),"Mono") == 0) 
	{ 
		// Create set of fd for select 
		fd_set setOfFd; 
 
		FD_ZERO (&setOfFd); 
		FD_SET (m_NewConnFd,&setOfFd); 
//		setOfFd.fd_count = 1; 
//		setOfFd.fd_array[0] = m_NewConnFd; 
 
		// Initiaize timeval structure 
		struct timeval waitingTime; 
		waitingTime.tv_sec = 0; 
		waitingTime.tv_usec = 1000; 
 
		int resultSelect; 
		int counter = 0; 
 
#ifdef _WIN32 
		resultSelect = select (0,&setOfFd,NULL,NULL,&waitingTime); 
#endif // _WIN32 
#ifdef linux 
		int nfd = m_NewConnFd + 1; 
		resultSelect = select (nfd,&setOfFd,NULL,NULL,&waitingTime); 
#endif // linux 
#ifdef __SCO__ 
		int nfd = m_NewConnFd + 1; 
		resultSelect = select (nfd,&setOfFd,NULL,NULL,&waitingTime); 
#endif // __SCO__ 
#ifdef __HPUX__ 
		int nfd = m_NewConnFd + 1; 
		resultSelect = select (nfd,&setOfFd,NULL,NULL,&waitingTime); 
#endif // __HPUX__ 
 
#ifdef _WIN32 
		if (resultSelect == SOCKET_ERROR) 
#endif // _WIN32 
#ifdef linux 
		if (resultSelect == -1) 
#endif // linux 
#ifdef __SCO__ 
		if (resultSelect == -1) 
#endif // __SCO__ 
#ifdef __HPUX__ 
		if (resultSelect == -1) 
#endif // __HPUX__ 
		{ 
			// Error in select 
			Trace (__FILE__,__LINE__,LOGMASK_COMM,"Error select"); 
		} 
 
		BOOL bExitLoop = FALSE; 
 
		while (resultSelect >= 1 && counter < 100 && bExitLoop == FALSE) 
		{ 
			counter++; 
			// Data ready to be red 
 
			Trace (__FILE__,__LINE__,LOGMASK_COMM,"Try to read message from socket"); 
 
			ReadMessageFromSocket (); 
 
			Trace (__FILE__,__LINE__,LOGMASK_COMM,"Message red successfully"); 
 
			if (m_CurrentMessage == NULL) 
			{ 
				// Set exit flag 
				bExitLoop = TRUE; 
			} 
			else 
			{ 
				// Tag the DispatchMessage with the current Connection ID 
				if (strcmp (m_CurrentMessage->GetName(),"DispatchMessage") == 0 && strcmp (m_CurrentMessage->GetType(),"Message") == 0) 
				{ 
					// It's a DispatchMessage supporting routing info 
					Trace (__FILE__,__LINE__,LOGMASK_COMM,"Add routing info to DispatchMessage : #DispatchKey#Routing#***CurrentConnectionID*** = %ld",m_ParentConnection->GetConnectionID()); 
					((CDispatchMessage *)m_CurrentMessage)->AddValueForKey ("#DispatchKey#Routing#***CurrentConnectionID***",m_ParentConnection->GetConnectionID()); 
				} 
 
				m_ReceiveStack->PutMessage (m_CurrentMessage); 
			} 
 
#ifdef _WIN32 
			resultSelect = select (0,&setOfFd,NULL,NULL,&waitingTime); 
#endif // _WIN32 
#ifdef linux 
			int nfd = m_NewConnFd + 1; 
			resultSelect = select (nfd,&setOfFd,NULL,NULL,&waitingTime); 
#endif // linux 
#ifdef __SCO__ 
			int nfd = m_NewConnFd + 1; 
			resultSelect = select (nfd,&setOfFd,NULL,NULL,&waitingTime); 
#endif // __SCO__ 
#ifdef __HPUX__ 
			int nfd = m_NewConnFd + 1; 
			resultSelect = select (nfd,&setOfFd,NULL,NULL,&waitingTime); 
#endif // __HPUX__ 
 
#ifdef _WIN32 
			if (resultSelect == SOCKET_ERROR) 
#endif // _WIN32 
#ifdef linux 
			if (resultSelect == -1) 
#endif // linux 
#ifdef __SCO__ 
			if (resultSelect == -1) 
#endif // __SCO__ 
#ifdef __HPUX__ 
			if (resultSelect == -1) 
#endif // __HPUX__ 
			{ 
				// Error in select 
				Trace (__FILE__,__LINE__,LOGMASK_COMM,"Error select"); 
			} 
 
		} 
 
		// Now check send stack 
#ifdef PASS_EXCEPTION 
        try 
#endif // PASS_EXCEPTION 
        { 
			counter = 0; 
			bExitLoop = FALSE;
 
        	while (m_SendStack->IsMessageAvailable() && counter < 100 && bExitLoop == FALSE) 
        	{ 
				counter++; 
        		CMessage *aMessage = m_SendStack->GetMessage(); 
     
        		if (aMessage != NULL) 
        		{ 
 	 				Trace (__FILE__,__LINE__,LOGMASK_COMM,"message name : %s",aMessage->GetMessageName()); 
 
        			// Multi pass serialization 
        			aMessage->SetSerialMultiPass(); 
        			aMessage->SetSerialMultiPassCount(); 
        			aMessage->Serialize (); 
     
        			aMessage->SetSerialMultiPassFill(); 
        			aMessage->Serialize (); 
     
        			SerializedObject *object = aMessage->GetSerializedObject(); 
 
					if (object == NULL) 
					{ 
						// Can't get serialized object 
						// Trace Error 
						delete aMessage; 
						return; 
					} 
 
        			if (SendSerializedObject (object) == FALSE) 
					{ 
						// Can't send object 
						// Trace Error 
 
						Trace (__FILE__,__LINE__,LOGMASK_COMM,"Can't send message"); 
 
						delete aMessage; 
 
						Trace (__FILE__,__LINE__,LOGMASK_COMM,"Message deleted"); 

						bExitLoop = TRUE;
						m_bSocketClosing = TRUE;
 					}
					else
					{
        			 
						Trace (__FILE__,__LINE__,LOGMASK_COMM,"Message sent"); 
 
        				delete aMessage; 
 
						Trace (__FILE__,__LINE__,LOGMASK_COMM,"Message deleted"); 
					}
        		} 
        	} 
        } 
#ifdef PASS_EXCEPTION 
        catch (...) 
        { 
        	// Error, do something 
			Trace (__FILE__,__LINE__,LOGMASK_COMM,"Exception raised"); 
		} 
#endif // PASS_EXCEPTION 
	} 
 
	// Error reading a message, connection disconnected 
	if (m_bMessageReadError == TRUE) 
	{ 
		// Client disconnect 
		Trace (__FILE__,__LINE__,LOGMASK_COMM,"Error reading message, exit socket thread"); 
		m_bCloseFlag = TRUE; 
		if (m_ParentConnection != NULL) 
		{ 
			// First send the connection_break message to the parent connection  
			if (m_ReceiveStack != NULL) 
			{ 
				CConnectionMessage_Break *breakMessage = new CConnectionMessage_Break; 
 
				if (breakMessage != NULL) 
				{ 
					m_ReceiveStack->PutMessage(breakMessage); 
				} 
			} 
			m_ParentConnection->SetConnectionBreak (); 
 
			// Close the socket 
 
#ifdef _WIN32 
			closesocket (m_NewConnFd); 
#endif //_WIN32 
#ifdef linux 
			close (m_NewConnFd); 
#endif //linux 
#ifdef __SCO__ 
			close (m_NewConnFd); 
#endif // __SCO__ 
#ifdef __HPUX__ 
			close (m_NewConnFd); 
#endif // __HPUX__ 
			m_NewConnFd = 0; 
		} 
	} 
 
	// Socket is closing 
	if (m_bSocketClosing == TRUE) 
	{ 
		m_bCloseFlag = TRUE; 
		if (m_ParentConnection != NULL) 
		{ 
			// First send the connection_break message to the parent connection  
			if (m_ReceiveStack != NULL) 
			{ 
				CConnectionMessage_Close *closeMessage = new CConnectionMessage_Close; 
 
				if (closeMessage != NULL) 
				{ 
					m_ReceiveStack->PutMessage(closeMessage); 
				} 
			} 

			m_ParentConnection->SetConnectionBreak (); 
 
			// Now close the socket 
#ifdef _WIN32 
			closesocket (m_NewConnFd); 
#endif //_WIN32 
#ifdef linux 
			close (m_NewConnFd); 
#endif //linux 
#ifdef __SCO__ 
			close (m_NewConnFd); 
#endif // __SCO__ 
#ifdef __HPUX__ 
			close (m_NewConnFd); 
#endif // __HPUX__ 
			m_NewConnFd = 0; 
		} 
	} 
 
	// Do we need to stop the socket ? 
	if (m_bCloseFlag == TRUE) 
	{ 
		Trace (__FILE__,__LINE__,LOGMASK_COMM,"Asking socket thread to stop"); 
 
#ifdef _WIN32 
		SetEvent(m_hCloseEvent); 
#endif //_WIN32 
#ifdef linux 
		pthread_mutex_lock (&m_InternalLock); 
		m_CloseFlag = TRUE; 
		pthread_mutex_unlock (&m_InternalLock); 
#endif //linux 
#ifdef __SCO__ 
		mutex_lock (&m_InternalLock); 
		m_CloseFlag = TRUE; 
		mutex_unlock (&m_InternalLock); 
#endif // __SCO__ 
#ifdef __HPUX__ 
		PASS_LOCK (&m_InternalLock); 
		m_CloseFlag = TRUE; 
		PASS_UNLOCK (&m_InternalLock); 
#endif // __HPUX__ 
	} 
} 
         
        void CConnectionSocket::SetStack (CMessageStack *aStack) 
        { 
        	m_ReceiveStack = aStack; 
        } 
         
        void CConnectionSocket::SetReceiveStack (CMessageStack *aStack) 
        { 
        	m_ReceiveStack = aStack; 
        } 
         
        void CConnectionSocket::SetSendStack (CMessageStack *aStack) 
        { 
        	m_SendStack = aStack; 
        } 
         
        void CConnectionSocket::SetConnection (CConnection *aConnection) 
        { 
        	m_ParentConnection = aConnection; 
        } 
         
        void CConnectionSocket::SetServerSession (CServerSession *aSession) 
        { 
        	m_ServerSession = aSession; 
        } 
         
#ifdef PASS_SSL 
        void CConnectionSocket::SetSecuredConnection (BOOL flag) 
        { 
        	m_bSecuredConnection = flag; 
        } 
         
        void CConnectionSocket::SetSSLSSL (SSL* ssl) 
        { 
        	m_SSLssl = ssl; 
        } 
 
        void CConnectionSocket::SetCertificateFile (char *file) 
        { 
        	if (file != NULL) 
        	{ 
        		if (m_szCertificateFile != NULL) 
        		{ 
        			delete [] m_szCertificateFile; 
        		} 
        		m_szCertificateFile = new char [(strlen (file)) + 1]; 
        		strcpy (m_szCertificateFile,file); 
        	} 
        } 
 
#endif //PASS_SSL 
 
void CConnectionSocket::ReadMessageFromSocket (void) 
{ 
int readLeft; 
 
	// Reset flags 
	m_bMessageReadOK = FALSE; 
	m_bMessageReadError = FALSE; 
 
	// Get serialized object 
	if (m_bCloseFlag == FALSE) 
	{ 
		SerializedObject *localObject = new SerializedObject; 
 
		// Clean structure 
		memset (localObject,0,sizeof(SerializedObject)); 
 
#ifdef PASS_SSL 
		if (m_bSecuredConnection == TRUE && m_SSLssl != NULL) 
		{ 
			Trace (__FILE__,__LINE__,LOGMASK_COMM,"Before first SSL_read"); 
 
			readLeft = SSL_readn (m_SSLssl,(char *)&localObject->nameSize,4); 
			if (readLeft == -1 || readLeft == 0) 
			{ 
				m_bMessageReadError = TRUE; 
			} 
 
			Trace (__FILE__,__LINE__,LOGMASK_COMM,"After first SSL_read"); 
 
			if (readLeft != -1 && readLeft != 0 && readLeft == 4) 
			{ 
				localObject->name = new char [localObject->nameSize]; 
 
				readLeft = SSL_readn (m_SSLssl, localObject->name, localObject->nameSize); 
				if (readLeft == -1 || readLeft == 0) 
				{ 
					m_bMessageReadError = TRUE; 
				} 
				if (readLeft != -1 && readLeft != 0 && readLeft == (int)localObject->nameSize) 
				{ 
					readLeft = SSL_readn (m_SSLssl,(char *)&localObject->typeSize,4); 
					if (readLeft == -1 || readLeft == 0) 
					{ 
						m_bMessageReadError = TRUE; 
					} 
					if (readLeft != -1 && readLeft != 0 && readLeft == 4) 
					{ 
						localObject->type = new char [localObject->typeSize]; 
 
						readLeft = SSL_readn (m_SSLssl, localObject->type, localObject->typeSize); 
						if (readLeft == -1 || readLeft == 0) 
						{ 
							m_bMessageReadError = TRUE; 
						} 
						if (readLeft != -1 && readLeft != 0 && readLeft == (int)localObject->typeSize) 
						{ 
							readLeft = SSL_readn (m_SSLssl, (char *)&localObject->serializedObjectSize, 4); 
							if (readLeft == -1 || readLeft == 0) 
							{ 
								m_bMessageReadError = TRUE; 
							} 
							if (readLeft != -1 && readLeft != 0 && readLeft == 4) 
							{ 
								localObject->serializedObject = new BYTE [localObject->serializedObjectSize]; 
								readLeft = SSL_readn (m_SSLssl, (char *)localObject->serializedObject, localObject->serializedObjectSize); 
								if (readLeft == -1 || readLeft == 0) 
								{ 
									m_bMessageReadError = TRUE; 
								} 
								if (readLeft != -1 && readLeft != 0 && readLeft == (int)localObject->serializedObjectSize) 
								{ 
									m_bMessageReadOK = TRUE; 
								} 
							} 
						} 
					} 
				} 
			} 
		} 
		else 
#endif //PASS_SSL 
		{ 
			unsigned long receiveSize;

			readLeft = Readn (m_NewConnFd,&receiveSize,4); 
			localObject->nameSize = ntohl (receiveSize);
			if (readLeft == -1) 
			{ 
				// Read error, connection broken 
				m_bMessageReadError = TRUE; 
			} 
			if (readLeft == 0) 
			{ 
				// Socket closing 
				m_bSocketClosing = TRUE; 
			} 
			if (readLeft != -1 && readLeft != 0 && readLeft == 4) 
			{ 
				localObject->name = new char [localObject->nameSize]; 
 
				readLeft = Readn (m_NewConnFd, localObject->name, localObject->nameSize); 
				if (readLeft == -1 || readLeft == 0) 
				{ 
					m_bMessageReadError = TRUE; 
				} 
				if (readLeft != -1 && readLeft != 0 && readLeft == (int)localObject->nameSize) 
				{ 

					readLeft = Readn (m_NewConnFd,&receiveSize,4); 
					localObject->typeSize = ntohl (receiveSize);
					if (readLeft == -1 || readLeft == 0) 
					{ 
						m_bMessageReadError = TRUE; 
					} 
					if (readLeft != -1 && readLeft != 0 && readLeft == 4) 
					{ 
						localObject->type = new char [localObject->typeSize]; 
 
						readLeft = Readn (m_NewConnFd, localObject->type, localObject->typeSize); 
						if (readLeft == -1 || readLeft == 0) 
						{ 
							m_bMessageReadError = TRUE; 
						} 
						if (readLeft != -1 && readLeft != 0 && readLeft == (int)localObject->typeSize) 
						{ 
							readLeft = Readn (m_NewConnFd, &receiveSize, 4); 
							localObject->serializedObjectSize = ntohl (receiveSize);
							if (readLeft == -1 || readLeft == 0) 
							{ 
								m_bMessageReadError = TRUE; 
							} 
							if (readLeft != -1 && readLeft != 0 && readLeft == 4) 
							{ 
								localObject->serializedObject = new BYTE [localObject->serializedObjectSize]; 
								readLeft = Readn (m_NewConnFd, localObject->serializedObject, localObject->serializedObjectSize); 
								if (readLeft == -1 || readLeft == 0) 
								{ 
									m_bMessageReadError = TRUE; 
								} 
								if (readLeft != -1 && readLeft != 0 && readLeft == (int)localObject->serializedObjectSize) 
								{ 
									// Message OK 
									m_bMessageReadOK = TRUE; 
								} 
							} 
						} 
					} 
				} 
			} 
		} 
 
		if (m_bMessageReadOK == TRUE) 
		{ 
			// Instanciate the new Message 
			char bufTempName[256]; 
			char bufTempType[256]; 
			memset (bufTempName,0,256); 
			memset (bufTempType,0,256); 
			memcpy (bufTempName,localObject->name,localObject->nameSize); 
			memcpy (bufTempType,localObject->type,localObject->typeSize); 
			Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"New message - name : %s type : %s",bufTempName,bufTempType); 
 
			CObjectManager *objectManager = CObjectManager::Instance(); 
			m_CurrentMessage = (CMessage *)objectManager->CreateBySerializedObject (localObject); 
		} 
		else 
		{ 
			// delete temp SerializedObject 
			delete localObject; 
			localObject = NULL; 
			m_CurrentMessage = NULL; 
		} 
	} 
} 
 
BOOL CConnectionSocket::SendSerializedObject (struct SerializedObject *anObject) 
{ 
    if (anObject == NULL) 
    { 
        return FALSE; 
    } 
 
#ifdef PASS_SSL 
        if (m_bSecuredConnection == TRUE) 
        { 
        	if (m_SSLssl == NULL) 
        	{ 
        		return FALSE; 
        	} 
        	else 
        	{ 
        		try 
        		{ 
      			if ((SSL_writen (m_SSLssl, (char *)&anObject->nameSize, 4)) == -1) 
        			{ 
        				return FALSE; 
        			} 
 
      			if ((SSL_writen (m_SSLssl, anObject->name, anObject->nameSize)) == -1) 
        			{ 
        				return FALSE; 
        			} 
 
      			if ((SSL_writen (m_SSLssl, (char *)&anObject->typeSize, 4)) == -1) 
        			{ 
        				return FALSE; 
        			} 
 
      			if ((SSL_writen (m_SSLssl, anObject->type, anObject->typeSize)) == -1) 
        			{ 
        				return FALSE; 
        			} 
 
      			if ((SSL_writen (m_SSLssl, (char *)&anObject->serializedObjectSize, 4)) == -1) 
        			{ 
        				return FALSE; 
        			} 
 
      			if ((SSL_writen (m_SSLssl, (char *)anObject->serializedObject, anObject->serializedObjectSize)) == -1) 
        			{ 
        				return FALSE; 
        			} 
 
        			return TRUE; 
        		} 
        		catch (...) 
        		{ 
        			return FALSE; 
        		} 
        	} 
        } 
        else 
#endif //PASS_SSL 
        { 
#ifdef PASS_EXCEPTION 
        	try 
#endif // PASS_EXCEPTION 
        	{ 
		  		Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"nameSize : %ld",anObject->nameSize); 

				unsigned long sendSize = htonl (anObject->nameSize);

        		if ((Writen (m_NewConnFd, &sendSize, 4)) == -1) 
        		{ 
        			return FALSE; 
        		} 
 
 
        		if ((Writen (m_NewConnFd, anObject->name, anObject->nameSize)) == -1) 
        		{ 
        			return FALSE; 
        		} 
			 
				Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"typesize :%ld",anObject->typeSize); 

				sendSize = htonl (anObject->typeSize);
 
        		if ((Writen (m_NewConnFd, &sendSize, 4)) == -1) 
        		{ 
        			return FALSE; 
        		} 
 
        		if ((Writen (m_NewConnFd, anObject->type, anObject->typeSize)) == -1) 
        		{ 
        			return FALSE; 
        		} 
 
				Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"serializedObject size : %ld",anObject->serializedObjectSize); 

				sendSize = htonl (anObject->serializedObjectSize);
 
        		if ((Writen (m_NewConnFd, &sendSize, 4)) == -1) 
        		{ 
        			return FALSE; 
        		} 
 
				Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"serializedObject size writen"); 
        		if ((Writen (m_NewConnFd, anObject->serializedObject, anObject->serializedObjectSize)) == -1) 
        		{ 
        			return FALSE; 
        		} 
				Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"serializedObject written"); 
 
        		return TRUE; 
        	} 
#ifdef PASS_EXCEPTION 
        	catch (...) 
        	{ 
        		return FALSE; 
        	} 
#endif // PASS_EXCEPTION 
        }
} 
         
int CConnectionSocket::Readn (int fd, void *vptr, size_t n) 
{ 
	int nleft; 
	int nread; 
	char *ptr; 
 
	ptr = (char *)vptr; 
	nleft = n; 
 
	while (nleft > 0) 
	{ 
#ifdef _WIN32 
		if (( nread = recv (fd,ptr,nleft,0)) == SOCKET_ERROR) 
#endif //_WIN32 
#ifdef linux 
		if (( nread = recv (fd,ptr,nleft,0)) == -1) 
#endif //linux 
#ifdef __SCO__ 
		if (( nread = recv (fd,ptr,nleft,0)) == -1) 
#endif // __SCO__ 
#ifdef __HPUX__ 
		if (( nread = recv (fd,ptr,nleft,0)) == -1) 
#endif // __HPUX__ 
		{ 
			return -1; 
		}  
		else if (nread == 0) 
		{ 
			break; 
		} 
		nleft -= nread; 
		ptr += nread; 
	} 
 
	return (n-nleft); 
}
 
int CConnectionSocket::Writen (int fd,const void *vptr, int n) 
{ 
    int nleft; 
    int nwritten; 
    const char *ptr; 
 
    ptr = (const char *)vptr; 
    nleft = n; 
 
    while (nleft > 0) 
    { 
#ifdef _WIN32 
        if ((nwritten = send(fd,ptr,nleft,0)) <= 0) 
#endif // _WIN32 
#ifdef linux 
        if ((nwritten = send(fd,ptr,nleft,MSG_DONTWAIT)) <= 0) 
#endif // linux 
#ifdef __SCO__ 
        if ((nwritten = send(fd,ptr,nleft,0)) <= 0)  // Was MSG_DONTWAIT but changed to old form "0"
#endif // __SCO__ 
#ifdef __HPUX__ 
        if ((nwritten = send(fd,ptr,nleft,0)) <= 0)
#endif // __HPUX__ 
        { 
#ifdef _WIN32 
		return -1; 
#endif // _WIN32 
#ifdef linux 
		// Get error 
		if (errno != EAGAIN) 
		{ 
        		return -1; 
		} 
		usleep (10); 
#endif // linux				 
#ifdef __SCO__ 
		// Get error 
		if (errno != EAGAIN) 
		{ 
        		return -1; 
		} 
		usleep (10); 
#endif // __SCO__				 
#ifdef __HPUX__ 
		// Get error 
		if (errno != EAGAIN) 
		{ 
        		return -1; 
		} 
		PASS_MILLISLEEP (10); 
#endif // __HPUX__				 
        } 
	else 
	{ 
        	nleft -= nwritten; 
		Trace (__FILE__,__LINE__,LOGMASK_COMM_EX,"byte written : %d left to write : %d",nwritten,nleft); 
        	ptr += nwritten; 
	} 
    } 
    return n; 
} 

void CConnectionSocket::Close (void) 
{ 
	// Disable send on the socket 
#ifdef _WIN32 
	shutdown (m_NewConnFd,SD_SEND); 
#endif // _WIN32 
#ifdef linux 
	shutdown (m_NewConnFd,1); 
#endif // linux 
#ifdef __SCO__ 
	shutdown (m_NewConnFd,1); 
#endif // __SCO__ 
#ifdef __HPUX__ 
	shutdown (m_NewConnFd,1); 
#endif // __HPUX__ 
} 
 
