// Connection_Dual.cpp: implementation of the CConnection_Dual class. 
// 
////////////////////////////////////////////////////////////////////// 
 
#include "../../Include/Comm/Connection.h" 
#include "../../Include/Comm/Connection_Dual.h" 
#include "../../Include/Comm/Message.h" 
#include "../../Include/Comm/ConnectionSender.h" 
#include "../../Include/Comm/ConnectionSocket.h" 
#include "../../Include/Comm/ConnectionListener.h" 
#include "../../Include/Comm/MessageStack.h" 
#include "../../Include/Base/ObjectManager.h" 
#include "../../Include/Comm/ConnectionMessage_Close.h" 
#include "../../Include/Comm/ConnectionMessage_OpenBack.h" 
#include "../../Include/Comm/ServerSession.h" 
 
#ifdef linux 
#include <stddef.h> 
#include <unistd.h> 
#include <string.h> 
#include <netdb.h> 
#include <stdio.h> 
#endif //linux 
 
#ifdef __SCO__ 
#include <stddef.h> 
#include <unistd.h> 
#include <string.h> 
#include <netdb.h> 
#include <stdio.h> 
#endif // __SCO__ 
 
#ifdef __HPUX__ 
#include <stddef.h> 
#include <unistd.h> 
#include <string.h> 
#include <netdb.h> 
#include <stdio.h> 
#endif // __HPUX__ 
  
////////////////////////////////////////////////////////////////////// 
// Construction/Destruction 
////////////////////////////////////////////////////////////////////// 
 
CConnection_Dual::CConnection_Dual() : CConnection ("Dual") 
{ 
	sender = NULL; 
	receiver = NULL; 
	socket = NULL; 
	m_RemoteServerIP = NULL; 
	m_BackIP = NULL; 
	m_RemoteServerName = NULL; 
	m_ReceivePort = 0; 
	m_RemoteServerPort = 0; 
	m_ulMessageIDCounter = 1; 
	m_bReceiverStarted = FALSE; 
	m_bSenderStarted = FALSE; 
	m_bServerConnection = FALSE; 
	m_SendStack = new CMessageStack; 
	m_ReceiveStack = new CMessageStack; 
	m_bOpenBackSent = FALSE; 
	m_bCloseSent = FALSE; 
	m_ServerSession = NULL; 
	m_bConnectionBreak = FALSE; 
	m_szConnectionName = NULL; 
	m_WaitMessageTimeOut = 60000; // Max 60 Sec default 
	m_bConnectionOpened = FALSE; 
 
#ifdef PASS_SSL 
	m_bSecuredConnection = FALSE; 
	m_szCertificateFile = NULL; 
	m_szPrivateKeyFile = NULL; 
#endif //PASS_SSL 

	PASS_INITLOCK (&lock); 
} 
         
CConnection_Dual::~CConnection_Dual() 
{ 
	if (m_RemoteServerIP != NULL) 
	{ 
		delete [] m_RemoteServerIP; 
	} 
 
	if (m_RemoteServerName != NULL) 
	{	 
		delete [] m_RemoteServerName; 
	} 
 
	if (m_BackIP != NULL) 
	{	 
		delete [] m_BackIP; 
	} 

	if (sender != NULL) 
	{ 
		sender->Kill(); 
		delete sender; 
	} 
 
	if (receiver != NULL) 
	{ 
		receiver->Kill(); 
		delete receiver; 
	} 
 
	if (socket != NULL) 
	{ 
		socket->Kill(); 
		delete socket; 
	} 
 
	delete m_SendStack; 
	delete m_ReceiveStack; 

	PASS_DESTROYLOCK (&lock); 
} 
         
BOOL CConnection_Dual::StartSender (void) 
{ 
	// Start the sender 
 
	if (sender == NULL) 
	{ 
		sender = new CConnectionSender; 
		sender->SetRemoteServerIP (m_RemoteServerIP); 
		sender->SetRemoteServerName (m_RemoteServerName); 
		sender->SetRemoteServerPort (m_RemoteServerPort); 
		sender->SetStack (m_SendStack); 
 
		#ifdef PASS_SSL 
		if (m_bSecuredConnection == TRUE) 
		{ 
			sender->SetCertificateFile (m_szCertificateFile); 
			sender->SetSecuredConnection (TRUE); 
		} 
		#endif //PASS_SSL 
 
		if (!(sender->Init())) 
		{ 
			m_bSenderStarted = FALSE; 
			return FALSE; 
		} 
 
		sender->SetTickTime (2); 
		sender->Start(); 
 
		m_bSenderStarted = TRUE; 
	} 
 
	return TRUE; 
} 
         
BOOL CConnection_Dual::StartReceiver (void) 
{ 
	// Start the receiver 
 
	if (receiver == NULL) 
	{ 
		receiver = new CConnectionListener; 
		receiver->SetPort (m_ReceivePort); 
		receiver->SetStack (m_ReceiveStack); 
		receiver->SetConnection (this); 
 
		#ifdef PASS_SSL 
		if (m_bSecuredConnection == TRUE) 
		{ 
			receiver->SetCertificateFile (m_szCertificateFile); 
			receiver->SetPrivateKeyFile (m_szPrivateKeyFile); 
			receiver->SetSecuredConnection (TRUE); 
		} 
		#endif //PASS_SSL 
  
		if (!(receiver->Initialize ())) 
		{ 
			m_bReceiverStarted = FALSE; 
			return FALSE; 
		} 
 
		receiver->SetTickTime (2); 
		receiver->Start(); 
 
		m_bReceiverStarted = TRUE; 
	} 
 
	return TRUE; 
} 
         
BOOL CConnection_Dual::StopSender (void) 
{ 
	if (sender != NULL) 
	{ 
		sender->Kill(); 
 
		delete sender; 
		sender = NULL; 
	} 
 
	m_bSenderStarted = FALSE; 
	m_bOpenBackSent = FALSE; 
 
	return TRUE; 
} 
 
BOOL CConnection_Dual::StopReceiver (void) 
{ 
	if (receiver != NULL) 
	{ 
		receiver->Kill(); 
 
		delete receiver; 
		receiver = NULL; 
	} 
 
	m_bReceiverStarted = FALSE; 
 
	return TRUE; 
} 
         
BOOL CConnection_Dual::Open (void) 
{ 
	if (m_bConnectionOpened == TRUE) 
	{ 
		// Connection already opened 
		return TRUE; 
	} 
 
#ifdef _WIN32 
	m_ulMessageIDCounter = (unsigned long)m_hThread;        		 
#endif //_WIN32 
 
#ifdef linux 
	m_ulMessageIDCounter = 1; 
#endif //linux 
 
#ifdef __SCO__ 
	m_ulMessageIDCounter = 1; 
#endif // __SCO__ 
 
#ifdef __HPUX__ 
	m_ulMessageIDCounter = 1; 
#endif // __HPUX__ 
  
	if (!(StartSender())) 
	{ 
		return FALSE; 
	} 
  
	if (!(StartReceiver())) 
	{ 
		return FALSE; 
	} 
 
	CConnectionMessage_OpenBack *message  = new CConnectionMessage_OpenBack; 
	// Get client IP 
 
	char bufferHostName[256]; 
	struct hostent *hostInfo;	// SCO ? OK!
	if (gethostname(bufferHostName,256) == 0) 
	{ 
		// Now get host information 
		hostInfo = gethostbyname (bufferHostName); 
	} 
 
	message->SetBackIP (m_BackIP); 
	message->SetBackPort (m_ReceivePort); 
 
	unsigned long messageID = SendMessage (message); 
 
	m_bOpenBackSent = TRUE; 
 
	CMessage *returnMessage = WaitMessageForID(messageID); 
 
	if (returnMessage == NULL) 
	{ 
		return FALSE; 
	} 
	else if (returnMessage->GetMessageID() == messageID) 
	{ 
		// Free return message 
		delete returnMessage; 
		m_bConnectionOpened = TRUE; 
		return TRUE; 
	} 
	else 
	{ 
		// Free return message 
		delete returnMessage; 
		return FALSE; 
	} 
 } 
         
        BOOL CConnection_Dual::Close (void) 
        { 
        	if (sender != NULL) 
        	{ 
        		// Send close signal 
        		CConnectionMessage_Close *messageClose = new CConnectionMessage_Close; 
         
 	     		unsigned long messageID = 0; // SCO ? OK!
				messageID = SendMessage (messageClose); 
 
        		m_bCloseSent = TRUE; 
         
        		// Now check if the sender is closed 
         
        		BOOL senderDeleted = FALSE; 
         
        		while (senderDeleted == FALSE) 
        		{ 
        			if (sender == NULL) 
        			{ 
        				senderDeleted = TRUE; 
        			} 
        			else 
        			{ 
        				if (sender->CanBeDeleted() == TRUE) 
        				{ 
        					senderDeleted = TRUE; 
        				} 
        				else 
        				{ 
        					senderDeleted = FALSE; 
        				} 
        			}
				
				PASS_MILLISLEEP (10); 
        		} 
         
        		// Delete Sender 
         
        		if (sender != NULL) 
        		{ 
        			delete sender; 
        			sender = NULL; 
        		} 
         
        		// Now close the listener 
         
        		if (receiver != NULL) 
        		{ 
        			// Close the listener 
        			receiver->Close(); 
        			receiver->Stop(); 
        			while (receiver->CanBeDeleted() == FALSE) 
        			{
					    PASS_MILLISLEEP (10); 
        			} 
        			delete receiver; 
        			receiver = NULL; 
  
        		} 
         
        		// Wait for the socket to close 
        		while (socket->CanBeDeleted() == FALSE) 
        		{ 
				    PASS_MILLISLEEP (10);
       			} 
        		delete socket; 
        		socket = NULL; 
        	} 
         
        	// Now clean the stacks 
        	while (m_SendStack->IsMessageAvailable() == TRUE) 
        	{ 
        		CMessage *message = m_SendStack->GetMessage (); 
        		delete message; 
        	} 
         
        	// Now clean the stacks 
        	while (m_ReceiveStack->IsMessageAvailable() == TRUE) 
        	{ 
        		CMessage *message = m_ReceiveStack->GetMessage (); 
        		delete message; 
        	} 
         
			m_bConnectionOpened = FALSE; 
        	return TRUE;	 
        } 
         
        void CConnection_Dual::SetServerIP (char *serverIP) 
        { 
        	if (serverIP != NULL) 
        	{ 
        		if (m_RemoteServerIP != NULL) 
        		{ 
        			delete [] m_RemoteServerIP; 
        		} 
        		m_RemoteServerIP = new char [(strlen (serverIP)) + 1]; 
        		strcpy (m_RemoteServerIP,serverIP); 
        	} 
        } 
         
        void CConnection_Dual::SetBackIP (char *backIP) 
        { 
        	if (backIP != NULL) 
        	{ 
        		if (m_BackIP != NULL) 
        		{ 
        			delete [] m_BackIP; 
        		} 
        		m_BackIP = new char [(strlen (backIP)) + 1]; 
        		strcpy (m_BackIP,backIP); 
        	} 
        } 
         
        void CConnection_Dual::SetServerName (char *serverName) 
        { 
        	if (serverName != NULL) 
        	{ 
        		if (m_RemoteServerName != NULL) 
        		{ 
        			delete [] m_RemoteServerName; 
        		} 
        		m_RemoteServerName = new char [(strlen (serverName)) + 1]; 
        		strcpy (m_RemoteServerName,serverName); 
        	} 
        } 
         
        void CConnection_Dual::SetSendPort (unsigned short port) 
        { 
        	m_RemoteServerPort = port; 
        } 
         
        void CConnection_Dual::SetReceivePort (unsigned short port) 
        { 
        	m_ReceivePort = port; 
        } 
         
        BOOL CConnection_Dual::SendObject (CObject *anObject) 
        { 
        	anObject->Serialize (); 
         
        	BOOL flag = sender->SendObject (anObject->GetSerializedObject());	 
         
        	delete anObject; 
         
        	return flag; 
        } 
         
        unsigned long CConnection_Dual::SendMessage (CMessage *aMessage) 
        {
		    PASS_LOCK (&lock); 

        	unsigned long returnID = 0; 
         
        	// Is the message valid ? 
        	if (aMessage == NULL) 
        	{ 
        		// Invalid message return 0; 
        		returnID = 0; 
        	} 
        	else 
        	{ 
        		// Is the connection open ? 
        		 
        		if (m_bServerConnection == FALSE) 
        		{ 
        			if (!IsSenderStarted()) 
        			{ 
					    PASS_UNLOCK (&lock);
        				return 0; 
        			} 
        		} 
         
        		if (aMessage->GetMessageID() == 0) 
        		{ 
        			aMessage->SetMessageID (m_ulMessageIDCounter++); 
        			returnID = m_ulMessageIDCounter - 1; 
        		} 
        		else 
        		{ 
        			returnID = aMessage->GetMessageID(); 
        		} 
         
        		m_SendStack->PutMessage (aMessage); 
        	} 
        
		    PASS_UNLOCK (&lock); 
         
        	return returnID; 
        } 
         
        CMessageStack *CConnection_Dual::GetReceiveStack (void) 
        { 
        	return m_ReceiveStack; 
        }  
         
        CMessageStack *CConnection_Dual::GetSendStack (void) 
        { 
        	return m_SendStack; 
        } 
         
        BOOL CConnection_Dual::IsReceiverStarted (void) 
        { 
        	return m_bReceiverStarted; 
        } 
         
        BOOL CConnection_Dual::IsSenderStarted (void) 
        { 
        	return m_bSenderStarted; 
        } 
         
	CMessage *CConnection_Dual::_GetMessageForID (unsigned long messageID) 
	{ 
#ifdef PASS_EXCEPTION 
      	try 
#endif // PASS_EXCEPTION 
      	{ 
    		return m_ReceiveStack->GetMessageForID (messageID); 
      	} 
#ifdef PASS_EXCEPTION 
      	catch (...) 
      	{ 
      		// Exception, try more 
  			return NULL; 
  		} 
#endif // PASS_EXCEPTION
	} 
     
        CMessage *CConnection_Dual::GetMessageForID (unsigned long messageID) 
        {
		    PASS_LOCK (&lock); 
         
	      	CMessage *localMessage = NULL; 
    		localMessage = _GetMessageForID (messageID); 
      
		    PASS_UNLOCK (&lock); 
       
	      	return localMessage; 
	} 
       
        CMessage *CConnection_Dual::WaitMessageForID (unsigned long messageID) 
        {
		    PASS_LOCK (&lock); 
        
        	if (messageID == 0) 
        	{ 
			    PASS_UNLOCK (&lock);
        		return NULL; 
        	} 
        	 
        	CMessage *returnMessage = NULL; 
        	unsigned long countTimeOut = 0; 
 
#ifdef PASS_EXCEPTION 
        	try  
#endif // PASS_EXCEPTION 
        	{ 
    		    while ((returnMessage = _GetMessageForID(messageID)) == NULL) 
       		    { 
  			        if (countTimeOut++ > m_WaitMessageTimeOut) 
       			    { 
       				    returnMessage = NULL; 
       				    break; 
       			    }
			        PASS_MILLISLEEP (10); 
        	    } 
           	} 
#ifdef PASS_EXCEPTION 
       	    catch (...) 
       	    { 
       		    returnMessage = NULL; 
       	    } 
#endif // PASS_EXCEPTION         

		    PASS_UNLOCK (&lock); 
         
        	return returnMessage; 
        } 
         
        CConnectionSender *CConnection_Dual::GetSender (void) 
        { 
        	return sender; 
        } 
         
        void CConnection_Dual::SetSocket (CConnectionSocket *aSocket) 
        { 
        	socket = aSocket; 
        } 
         
        void CConnection_Dual::SetSender (CConnectionSender *aSender) 
        { 
        	sender = aSender; 
        } 
         
#ifdef PASS_SSL 
        void CConnection_Dual::SetSecuredConnection (BOOL flag) 
        { 
        	m_bSecuredConnection = flag; 
        } 
         
        void CConnection_Dual::SetSSLCTX (SSL_CTX *ctx) 
        { 
        	m_SSLctx = ctx; 
        } 
         
        void CConnection_Dual::SetCertificateFile (char *file) 
        { 
        	if (file != NULL) 
        	{ 
        		if (m_szCertificateFile != NULL) 
        		{ 
        			delete [] m_szCertificateFile; 
        		} 
        		m_szCertificateFile = new char [(strlen (file)) + 1]; 
        		strcpy (m_szCertificateFile,file); 
        	} 
        } 
         
        char *CConnection_Dual::GetCertificateFile (void) 
        { 
        	return m_szCertificateFile; 
        } 
         
        void CConnection_Dual::SetPrivateKeyFile (char *file) 
        { 
        	if (file != NULL) 
        	{ 
        		if (m_szPrivateKeyFile != NULL) 
        		{ 
        			delete [] m_szPrivateKeyFile; 
        		} 
        		m_szPrivateKeyFile = new char [(strlen (file)) + 1]; 
        		strcpy (m_szPrivateKeyFile,file); 
        	} 
        } 
         
#endif //PASS_SSL 
   
void CConnection_Dual::Tick (void) 
{ 
// Check if the send and the socket can be deleted 
// If these two can be deleted, delete the CServerSession Object 
// And set owned CanBeDeleted flag 
 
    BOOL bStopSocket = FALSE; 
    BOOL bStopSender = FALSE; 
 
	if (m_bServerConnection == TRUE) 
	{ 
		if (m_bConnectionBreak == TRUE) 
		{ 
		// The connection was broken 
		// Stop sender (socket is already stopped) 
			if (sender != NULL) 
			{	 
				sender->Stop(); 
			} 
		} 
 
		if (sender != NULL) 
		{ 
			if (sender->CanBeDeleted()) 
			{ 
				bStopSender = TRUE; 
			} 
		} 
 
		if (socket != NULL) 
		{ 
			if (socket->CanBeDeleted()) 
			{ 
				bStopSocket = TRUE; 
			} 
		} 
 
		if ((bStopSender == TRUE || sender == NULL) && (bStopSocket == TRUE || socket == NULL)) 
		{ 
			// First stop the session 
			if (m_ServerSession != NULL) 
			{ 
				m_ServerSession->Stop(); 
				delete m_ServerSession; 
				m_ServerSession = NULL; 
			} 
 
			// Sender and Socket can be deleted 
			// Stop them, stop ServerSession, set CloseFalg 
			if (sender != NULL) 
			{ 
				delete sender; 
				sender = NULL; 
			} 
 
			if (socket != NULL) 
			{ 
				delete socket; 
				socket = NULL; 
			} 
 
			m_bSenderStarted = FALSE; 
			m_bOpenBackSent = FALSE; 
 
#ifdef _WIN32 
			SetEvent(m_hCloseEvent); 
#endif //_WIN32 
 
#ifdef linux 
			pthread_mutex_lock (&m_InternalLock); 
			m_CloseFlag = TRUE; 
			pthread_mutex_unlock (&m_InternalLock); 
#endif //linux 
 
#ifdef __SCO__ 
			mutex_lock (&m_InternalLock); 
			m_CloseFlag = TRUE; 
			mutex_unlock (&m_InternalLock); 
#endif // __SCO__ 
 
#ifdef __HPUX__ 
			PASS_LOCK (&m_InternalLock); 
			m_CloseFlag = TRUE; 
			PASS_UNLOCK (&m_InternalLock); 
#endif // __HPUX__ 
 
		} 
	} 
} 
         
void CConnection_Dual::SetServerSession (CServerSession *aSession) 
{ 
	m_ServerSession = aSession; 
} 
 
BOOL CConnection_Dual::SetConnectionParam (CStringToObjectCollection *param) 
{ 
	// just to implement the abstract method 
	return TRUE; 
} 
 
