        // MessageHandler.cpp: implementation of the CMessageHandler class. 
        // 
        ////////////////////////////////////////////////////////////////////// 
         
        #include "../../Include/Comm/MessageHandler.h" 
        #include "../../Include/Comm/Message.h" 
        #include "../../Include/Comm/Connection.h" 
 
#ifdef linux 
  #include <stddef.h> 
  #include <string.h> 
#endif //linux 
 
#ifdef __SCO__ 
  #include <stddef.h> 
  #include <string.h> 
#endif // __SCO__ 
 
          
        ////////////////////////////////////////////////////////////////////// 
        // Construction/Destruction 
        ////////////////////////////////////////////////////////////////////// 
         
        CMessageHandler::CMessageHandler() : CObject ("MessageHandler","MessageHandler") 
        { 
 	     	m_Message = NULL; 
 	     	m_szMessageName = NULL; 
        } 
         
        CMessageHandler::CMessageHandler(char *name) : CObject (name,"MessageHandler") 
        { 
 	     	m_Message = NULL; 
 	     	m_szMessageName = NULL; 
        } 
         
        CMessageHandler::~CMessageHandler() 
        { 
        	if (m_szMessageName != NULL) 
        	{ 
        		delete m_szMessageName; 
        	} 
        } 
         
        void CMessageHandler::SetMessage (CMessage* message) 
        { 
        	m_Message = message; 
        } 
         
        void CMessageHandler::SetConnection (CConnection *connection) 
        { 
    		m_Connection = connection; 
        } 
     
        void CMessageHandler::SetMessageNameHandled (char *messageName) 
        { 
        	if (messageName != NULL) 
        	{ 
        		if (m_szMessageName != NULL) 
        		{ 
        			delete [] m_szMessageName; 
        		} 
        		m_szMessageName = new char [(strlen (messageName)) + 1]; 
        		strcpy (m_szMessageName,messageName); 
        	} 
        } 
         
        char *CMessageHandler::GetMessageNameHandled (void) 
        { 
        	return m_szMessageName; 
        } 
