    // ServerSession.cpp: implementation of the CServerSession class. 
    // 
    ////////////////////////////////////////////////////////////////////// 
    #include <stdio.h> 
     
    #include "../../Include/Comm/ServerSession.h" 
    #include "../../Include/Base/LongToObjectCollection.h" 
    #include "../../Include/Base/ObjectManager.h" 
    #include "../../Include/Comm/Message.h" 
    #include "../../Include/Comm/MessageStack.h" 
    #include "../../Include/Comm/MessageHandler.h" 
    #include "../../Include/Comm/Connection.h" 
 
#ifdef linux 
#include <stddef.h> 
#include <string.h> 
#endif //linux 
     
#ifdef __SCO__ 
#include <stddef.h> 
#include <string.h> 
#endif // __SCO__ 
     
 
    ////////////////////////////////////////////////////////////////////// 
    // Construction/Destruction 
    ////////////////////////////////////////////////////////////////////// 
     
    CServerSession::CServerSession() 
    { 
    	m_SendStack = NULL; 
    	m_ReceiveStack = NULL; 
	  	m_Connection = NULL; 
    } 
     
    CServerSession::CServerSession(char *name) : CThread (name,"ServerSession") 
    { 
    	m_SendStack = NULL; 
    	m_ReceiveStack = NULL; 
		m_Connection = NULL; 
    } 
     
    CServerSession::~CServerSession() 
    { 
     
    } 
     
    void CServerSession::SetSendStack (CMessageStack *aStack) 
    { 
    	m_SendStack = aStack; 
    } 
     
    void CServerSession::SetReceiveStack (CMessageStack *aStack) 
    { 
    	m_ReceiveStack = aStack; 
    } 
     
  void CServerSession::SetConnection (CConnection *connection) 
  { 
  	m_Connection = connection; 
  } 
   
  CConnection *CServerSession::GetConnection (void) 
  { 
  	return m_Connection; 
  }
