// ServerSessionDefault.cpp: implementation of the ServerSessionDefault class. 
// 
////////////////////////////////////////////////////////////////////// 
 
#include "../../Include/Comm/ServerSessionDefault.h" 
 
#include <stdio.h> 
 
#include "../../Include/Base/LongToObjectCollection.h" 
#include "../../Include/Base/ObjectManager.h" 
#include "../../Include/Base/LoggerManager.h" 
#include "../../Include/Comm/Message.h" 
#include "../../Include/Comm/MessageStack.h" 
#include "../../Include/Comm/MessageHandler.h" 
#include "../../Include/Comm/Connection.h" 
 
#ifdef linux 
#include <stddef.h> 
#include <string.h> 
#endif //linux 
     
#ifdef __SCO__ 
#include <stddef.h> 
#include <string.h> 
#endif // __SCO__ 
     
#ifdef __HPUX__ 
#include <stddef.h> 
#include <string.h> 
#endif // __HPUX__ 
     
  
////////////////////////////////////////////////////////////////////// 
// Construction/Destruction 
////////////////////////////////////////////////////////////////////// 
 
CServerSessionDefault::CServerSessionDefault() : CServerSession ("ServerSessionDefault") 
{ 
 
} 
 
CServerSessionDefault::~CServerSessionDefault() 
{ 
 
} 
 
void CServerSessionDefault::PreRun (void) 
{ 
} 
 
void CServerSessionDefault::PostRun (void) 
{ 
} 
 
void CServerSessionDefault::Tick (void) 
{ 
    CObjectManager *objectManager = PASS_GET_OBJECTMANAGER; 
	unsigned long ulCounter = 0;
 
    // Get MessageHandle collection from object manager 
    CLongToObjectCollection *tempCollection = NULL; 
 
    if (m_ReceiveStack != NULL && m_SendStack != NULL) 
    { 
    	// Check for new message 
    	while (m_ReceiveStack->IsMessageAvailable() == TRUE && ulCounter < 50) 
    	{ 
    		CMessage *message = m_ReceiveStack->GetMessage(); 
 
    		tempCollection = objectManager->GetObjectsForType ("MessageHandler"); 
 
    		if (tempCollection != NULL && message != NULL) 
    		{ 
				Trace (__FILE__,__LINE__,LOGMASK_COMM,"New Message received : %s , message name : %s",message->GetName(),message->GetMessageName()); 
 
    			// Check for the right handler 
    			ULONG32 objectCount = tempCollection->GetCount(); 
    			ULONG32 i; 
				BOOL bHandlerFound = FALSE; 
 
    			for (i=0;i<objectCount;i++) 
    			{ 
    				CMessageHandler *handler = (CMessageHandler *)tempCollection->Lookup (i); 
 
    				if (handler != NULL) 
    				{ 
    					char *messageHandled = handler->GetMessageNameHandled (); 
    					char *messageName = message->GetMessageName (); 
#ifdef PASS_EXCEPTION 
						try 
#endif
						{ 
 
#ifdef linux  
  							if (messageName != NULL && messageHandled != NULL) 
#endif // linux 
#ifdef __SCO__  
  							if (messageName != NULL && messageHandled != NULL) 
#endif // __SCO__ 
#ifdef __HPUX__  
  							if (messageName != NULL && messageHandled != NULL) 
#endif // __HPUX__ 
#ifdef _WIN32 
  							if (messageName != NULL && messageHandled != NULL && (unsigned long)messageName != 0xdddddddd && (unsigned long)messageName != 0xfeeefeee) 
#endif // _WIN32 
    						{ 
    							if (strcmp (messageName,messageHandled) == 0) 
    							{ 
    								// Found the right handler 
  									Trace (__FILE__,__LINE__,LOGMASK_COMM,"Handler Found : %s", handler->GetName()); 
 
									bHandlerFound = TRUE; 
  								 
    								CMessageHandler *localHandler =  
    									(CMessageHandler *)objectManager->CreateByNameAndType (handler->GetName(),"MessageHandler"); 
 
    								if (localHandler != NULL) 
    								{ 
 
  										Trace (__FILE__,__LINE__,LOGMASK_COMM,"Handler created : %s , now try to execute",handler->GetName()); 
 
    									localHandler->SetMessage (message); 
  										localHandler->SetConnection (m_Connection); 
    									localHandler->Execute (); 
 
    									// Send the message back to client 
    									m_SendStack->PutMessage(message); 
    									// Free message handler 
    									delete localHandler; 
    								} 
  									else 
  									{ 
  										Trace (__FILE__,__LINE__,LOGMASK_COMM,"Can't create handler : %s",handler->GetName()); 
  									} 
								} 
							} 
						}
#ifdef PASS_EXCEPTION 						
    					catch (...) 
    					{ 
							Trace (__FILE__,__LINE__,LOGMASK_COMM,"EXCEPTION raised while executing handler : %s",handler->GetName()); 
    					} 
#endif
    				} 
    			} 
 
				if (bHandlerFound == FALSE) 
				{ 
                    if (!m_Connection->GetConnectionBreak())
                    {
    				    CMessageHandler *localHandler = (CMessageHandler *)objectManager->CreateByNameAndType ("DefaultHandler", "MessageHandler"); 

    				    if (localHandler != NULL) 
    				    { 
    					    localHandler->SetMessage (message); 
  						    localHandler->SetConnection (m_Connection); 
    					    localHandler->Execute (); 

    					    // Send the message back to client 
    					    m_SendStack->PutMessage(message); 
    					    // Free message handler 
    					    delete localHandler; 
    				    }
                    }
                    else
                    {
					    delete message; 
                    }
				} 
 
    			delete tempCollection; 
    			tempCollection = NULL; 

				ulCounter++;
    		} 
    	} 
    } 
  } 

CObject *CServerSessionDefault::Clone (void) 
{ 
	CServerSessionDefault *tempObject = new CServerSessionDefault; 
	return (CObject *) tempObject; 
} 
