// CardChangeMonitor.cpp: implementation of the CCardChangeMonitor class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "CardChangeMonitor.h"
#include "PCSCManager.h"
#include "ReaderState.h"

struct tAtrTable 
{
	const BYTE *atr;
	size_t atr_len;
};

static struct tAtrTable BelpicAtrs[] = 
{
	/* Belpic Applet V1.1 */
	{ (const BYTE *) "\x3B\x98\x13\x40\x0A\xA5\x03\x01\x01\x01\xAD\x13\x11", 13 },
	/* Final with new EMV-compatible ATR */
	{ (const BYTE *) "\x3B\x98\x94\x40\x0A\xA5\x03\x01\x01\x01\xAD\x13\x10", 13 },
	/* Belpic Applet V5 + Final with ATR modif for Xiring reader */
	//{ (const u8 *) "\x3B\x98\x11\x40\xFF\xA5\x03\x01\x01\x01\xAD\x13\x10", 13, BELPIC_EID },
	/* Belpic Applet V5 + Final */
	{ (const BYTE *) "\x3B\x98\x94\x40\xFF\xA5\x03\x01\x01\x01\xAD\x13\x10", 13 },
	/* Belpic Applet V3 + V4 */
	/*{ (const u8 *) "\x3B\x98\x11\x40\xFF\xA5\x03\x01\x01\x01\xAD\x13\x04", 13, BELPIC_EID },*/
	/* Belpic Applet V2 */
	/*{ (const u8 *) "\x3B\x68\x00\x00\x29\x05\x01\x02\x01\xAD\x13\x03", 12, BELPIC_EID },*/
	{ NULL }
};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCardChangeMonitor::CCardChangeMonitor() : CThread ("CardChangeMonitor")
{
	SetTickTime (100);
    m_pPCSCManager = NULL;
    m_bCanSuspend = FALSE;
    m_bSuspend = FALSE;
}

CCardChangeMonitor::~CCardChangeMonitor()
{
   	ULONG32 position = 0; 
    char szKey[256] = {0}; 
    CObject *pObject = m_readerStates.GetFirst (&position, szKey, sizeof(szKey));

    while (pObject != NULL) 
    {      
        delete pObject;
        pObject = m_readerStates.GetNext (&position, szKey, sizeof(szKey)); 
    }
}

void CCardChangeMonitor::SetPCSCManager(CPCSCManager *pManager)
{
    m_pPCSCManager = pManager;
}

void CCardChangeMonitor::Tick (void)
{
    if(m_bSuspend)
        return;

    m_bCanSuspend = FALSE;
    SCARDCONTEXT hContext = 0;
    if(m_pPCSCManager != NULL)
    {
        hContext = m_pPCSCManager->GetContextHandle();
    }
    if(hContext != 0)
    {
        SCARD_READERSTATE_A rgscState[MAXIMUM_SMARTCARD_READERS] = {0};
        long  lReturn;
        int iCount = 0;
        int i, j;
        unsigned long cchReaders = 0;

        // Determine which readers are available.
        lReturn = SCardListReaders(hContext, NULL, NULL,  &cchReaders );
        if ( SCARD_S_SUCCESS != lReturn )
        {
            return;
        }

        char *pszReaders = new char[cchReaders];
        memset(pszReaders, 0, cchReaders);
        lReturn = SCardListReaders(hContext, NULL, pszReaders,  &cchReaders );
        if ( SCARD_S_SUCCESS != lReturn )
        {
            delete [] pszReaders;
            return;
        }

        // Place the readers into the state array.
        char *pszRdr = pszReaders;
        for ( i = 0; i < MAXIMUM_SMARTCARD_READERS; i++ )
        {
            if ( 0 == *pszRdr )
                break;
            CReaderState *pReaderState = NULL;
            pReaderState = (CReaderState *)m_readerStates.Lookup(pszRdr);
            if(pReaderState == NULL)
            {
                pReaderState = new CReaderState();
                pReaderState->SetState(SCARD_STATE_UNAWARE);
                m_readerStates.Add(pszRdr, pReaderState);
            }
            rgscState[i].szReader = pszRdr;
            rgscState[i].dwCurrentState = SCARD_STATE_UNAWARE;
       		rgscState[i].dwEventState = SCARD_STATE_UNAWARE;
            pszRdr += strlen(pszRdr) + 1;
        }
        iCount = i;
        
        // If any readers are available, proceed.
        if ( iCount > 0 )
        {
            lReturn = SCardGetStatusChange(hContext, 0, rgscState, iCount );
            if ( SCARD_S_SUCCESS == lReturn )
            {
                for (j = 0; j < iCount; j++)
                {
                    CReaderState *pReaderState = NULL;
                    pReaderState = (CReaderState *)m_readerStates.Lookup((char *)rgscState[j].szReader);
                    if(pReaderState != NULL)
                    {
                        unsigned long ulState = pReaderState->GetState();
                        if((ulState ==  SCARD_STATE_UNAWARE || ulState ==  SCARD_STATE_EMPTY) && SCARD_STATE_PRESENT & rgscState[j].dwEventState)
                        {
                            pReaderState->SetState(SCARD_STATE_PRESENT);
                            // Card Inserted
                            if(MatchAtr(rgscState[j].rgbAtr, rgscState[j].cbAtr))
                            {
                                m_pPCSCManager->EventCardState(SCARD_STATE_PRESENT, rgscState[j].szReader);
                            }
                        }
                        else if((ulState ==  SCARD_STATE_PRESENT || ulState ==  SCARD_STATE_UNAWARE) && SCARD_STATE_EMPTY & rgscState[j].dwEventState)
                        {
                            // Card Removed
                            pReaderState->SetState(SCARD_STATE_EMPTY); 
                            m_pPCSCManager->EventCardState(SCARD_STATE_EMPTY, rgscState[j].szReader);
                        }
                    }
                }
            }
        }
        delete [] pszReaders;
    }
    m_bCanSuspend = TRUE;
}

BOOL CCardChangeMonitor::MatchAtr(BYTE *atr, DWORD atr_len)
{
	for (int i = 0; BelpicAtrs[i].atr != NULL; i++) 
    {
		if (BelpicAtrs[i].atr_len != atr_len)
			continue;
		if (memcmp(BelpicAtrs[i].atr, atr, atr_len) != 0)
			continue;
		return TRUE;
	}
    return FALSE;
}

void CCardChangeMonitor::Suspend()
{
    ULONG ulCounter = 0;
   	ULONG32 position = 0; 
    char szKey[256] = {0}; 

    m_bSuspend = TRUE;
    while (!m_bCanSuspend && ulCounter < 200)
    {
        PASS_MILLISLEEP(10);
        ulCounter++;
    }

    if(m_pPCSCManager != NULL)
    {
        m_pPCSCManager->Suspend(); 
    }

    CObject *pObject = m_readerStates.GetFirst (&position, szKey, sizeof(szKey));

    while (pObject != NULL) 
    {
        CReaderState *pReaderState =  (CReaderState *)pObject;
        pReaderState->SetState(SCARD_STATE_UNAWARE); 
        pObject = m_readerStates.GetNext (&position, szKey, sizeof(szKey)); 
    }
}

void CCardChangeMonitor::Resume()
{
    m_bSuspend = FALSE;
}
