// TransactionStack.h: interface for the CTransactionStack class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TRANSACTIONSTACK_H__F57690A6_294B_4970_947E_7B659496EECE__INCLUDED_)
#define AFX_TRANSACTIONSTACK_H__F57690A6_294B_4970_947E_7B659496EECE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <time.h>

class CTransactionStack : public CThread
{
public:
	CTransactionStack();
	virtual ~CTransactionStack();

	void AddHandle(SCARDHANDLE hCard);
	int IsHandleAvailable (SCARDHANDLE hCard);
	void DeleteHandle(SCARDHANDLE hCard);
	void DeleteAllHandle(SCARDHANDLE hCard);

	void SetMaxTime (long lSec);
	void Tick (void);
protected:

	PASS_SYNCH lock;

	struct __TransactionStack 
	{
		SCARDHANDLE hCard;
		time_t time;
        long lLockCount;
		__TransactionStack *next;
	};

	__TransactionStack *m_StackTop;
	__TransactionStack *m_StackBottom;

	unsigned long m_ulAppCount;
	long m_lMaxTime;
};

#endif // !defined(AFX_TRANSACTIONSTACK_H__F57690A6_294B_4970_947E_7B659496EECE__INCLUDED_)
