/////////////////////////////////////////////////////////////////////////////
// Name:        wxmainapp.cpp
// Author:      XX
// Created:     XX/XX/XX
// Copyright:   
/////////////////////////////////////////////////////////////////////////////

// Include private headers
#include "wxmainapp.h"

#define EIDSERVICE_CURRENT_VERSION "2.3.13"
#ifdef _WIN32
    #pragma message( "*** Current service version is " EIDSERVICE_CURRENT_VERSION " ***") 
#endif

#ifndef _WIN32
    #define LOCK_FILE	"/tmp/belpcsc.lock"
    #define RUNNING_DIR	"/tmp"
    #define PID_FILE	"/var/run/belpcscd.pid"
    #include <fcntl.h>
    #include <signal.h>
    #include <stdlib.h>
    #include <sys/unistd.h>
#endif


#ifdef _WIN32
// WDR: class implementations

//------------------------------------------------------------------------------
// MyFrame
//------------------------------------------------------------------------------

// WDR: event table for MyFrame

BEGIN_EVENT_TABLE(MyFrame,wxFrame)
    EVT_MENU(ID_QUIT, MyFrame::OnQuit)
    EVT_CLOSE(MyFrame::OnCloseWindow)
END_EVENT_TABLE()

MyFrame::MyFrame( wxWindow *parent, wxWindowID id, const wxString &title,
    const wxPoint &position, const wxSize& size, long style ) :
    wxFrame( parent, id, title, position, size, style )
{

}

// WDR: handler implementations for MyFrame

void MyFrame::OnQuit( wxCommandEvent &event )
{
     Close( TRUE );
}

void MyFrame::OnCloseWindow( wxCloseEvent &event )
{
    // if ! saved changes -> return
    Destroy();
#ifdef _WIN32
    ::PostQuitMessage(0);
#endif
}

IMPLEMENT_APP(MyApp)

#else

MyApp* MyApp::m_pApp = NULL;

#endif

//------------------------------------------------------------------------------
// MyApp
//------------------------------------------------------------------------------

MyApp::MyApp()
{
#ifdef _WIN32
    m_pServiceStarter = NULL;
#else
    m_pApp = this;
    m_FileLock = -1;
#endif
    m_pLogfile = NULL;
    m_pPCSCManager = NULL;
    m_pApplicationManager = NULL;
    m_pCardChangeMonitor = NULL;
    m_pCRLScheduler = NULL;
    m_pDefaultHandler = NULL;
    m_pSCardHandler = NULL;
    m_bHibernate = TRUE;
}


bool MyApp::OnInit()
{
#ifdef _WIN32
    #ifdef _DEBUG
        MyFrame *frame = new MyFrame( NULL, -1, wxT("Belpic PC/SC Service"), wxPoint(20,20), wxSize(500,100) );
        frame->Show( TRUE );
    #else
        MyFrame *frame = new MyFrame( NULL, -1, wxT("Belpic PC/SC Service"), wxPoint(20,20), wxSize(500,100) );
		// Start server
        BOOL bNT = TRUE;
        if(wxWIN95 == wxGetOsVersion())
        {
            bNT = FALSE;
        }

        wxDynamicLibrary serviceLoader("Advapi32");
        if(serviceLoader.IsLoaded())
        {
            void *psrv = (void*)::GetProcAddress( serviceLoader.GetLibHandle(), "RegisterServiceCtrlHandlerExA" );
            if(psrv == NULL)
            {
                m_bHibernate = FALSE;
            }
            serviceLoader.Unload();
        }

        if(bNT)
        {
		    // Start the service controller handler
		    m_pServiceStarter = new ServiceStarter();
		    m_pServiceStarter->Start();
        }
        else
        {
            HANDLE hMutexOneInstance = CreateMutex( NULL, FALSE, _T("BELPIC_SERVICE_RUN"));
            bool AlreadyRunning = ( GetLastError() == ERROR_ALREADY_EXISTS || GetLastError() == ERROR_ACCESS_DENIED);
            if(AlreadyRunning)
            {
                return FALSE;
            }
            typedef DWORD (WINAPI *TRegisterServiceProcess)(DWORD,DWORD);
            TRegisterServiceProcess pReg;
            wxDynamicLibrary win9XLoader("kernel32");
            if(win9XLoader.IsLoaded())
            {
                pReg = (TRegisterServiceProcess)::GetProcAddress( win9XLoader.GetLibHandle(), "RegisterServiceProcess");
                if(pReg != NULL)
                {
                    pReg(0,1);
                }
                win9XLoader.Unload();
            }
        }
    #endif
#else
    if (daemon(0, 0) < 0)
        return FALSE;         

    signal(SIGHUP, SignalHandler); /* catch hangup signal */
    signal(SIGTERM, SignalHandler); /* catch kill signal */
    // Running a Single Copy
    m_FileLock = open(LOCK_FILE, O_RDWR | O_CREAT, 0640);
    if (m_FileLock < 0) exit(1); /* can not open */
    if (lockf(m_FileLock, F_TLOCK, 0) < 0) 
    {
        exit(0); /* can not lock */
    }
    // Store PID
    FILE *fpid = NULL;

    if ((fpid = fopen(PID_FILE, "wb")) != NULL)
    {
	    fprintf(fpid, "%u\n", (unsigned) getpid());
	    fclose(fpid);
    }            
#endif

    MainStart();

    return TRUE;
}

int MyApp::OnExit()
{
    MainStop();
    return 0;
}

#ifndef _WIN32
void MyApp::AtExit()
{
    OnExit();
    unlink(PID_FILE);
    if(m_FileLock >= 0)
    {
        close(m_FileLock);
        m_FileLock = -1;
    }
    unlink(LOCK_FILE);
    exit(0);
}

void MyApp::SignalHandler(int iSigNr)
{
    if(SIGTERM == iSigNr || SIGHUP == iSigNr)
    {
        m_pApp->AtExit();
    }
}


void MyApp::Daemon()
{
    int i, lfp;
    char str[10] = {0};
	if(getppid() == 1) return; /* already a daemon */
	i = fork();
	if (i<0) exit(1); /* fork error */
	if (i>0) exit(0); /* parent exits */
	/* child (daemon) continues */
	setsid(); /* obtain a new process group */
	for (i = getdtablesize(); i >= 0; --i) close(i); /* close all descriptors */
	i = open("/dev/null", O_RDWR); dup(i); dup(i); /* handle standard I/O */
	umask(027); /* set newly created file permissions */
	chdir(RUNNING_DIR); /* change running directory */
	lfp = open(LOCK_FILE, O_RDWR | O_CREAT, 0640);
	if (lfp < 0) exit(1); /* can not open */
	if (lockf(lfp, F_TLOCK, 0) < 0) exit(0); /* can not lock */
	/* first instance continues */
	sprintf(str,"%d\n",getpid());
	write(lfp, str, strlen(str)); /* record pid to lockfile */
	//signal(SIGCHLD, SIG_IGN); /* ignore child */
	//signal(SIGTSTP, SIG_IGN); /* ignore tty signals */
	//signal(SIGTTOU, SIG_IGN);
	//signal(SIGTTIN, SIG_IGN);
	signal(SIGHUP, SignalHandler); /* catch hangup signal */
	signal(SIGTERM, SignalHandler); /* catch kill signal */
}

int main(int argc, char **argv)
{
    wxApp::CheckBuildOptions(wxBuildOptions());

    wxInitializer initializer;
    if ( !initializer )
    {
        fprintf(stderr, "Failed to initialize the wxWindows library, aborting.");

        return -1;
    }
    MyApp *pTheApp= new MyApp();
    pTheApp->OnInit();
    
    while(1) sleep(1); /* run */
}
#endif

void MyApp::MainStart()
{
		DWORD dwCheckPoint = 0;
   		CObjectManager *pObjectManager = PASS_GET_OBJECTMANAGER;
        m_pDefaultHandler = new CDefaultHandler();
        m_pSCardHandler = new CSCardHandler();
        pObjectManager->RegisterObject(m_pDefaultHandler);
        pObjectManager->RegisterObject(m_pSCardHandler);

		SetServiceProgress(SERVICE_START_PENDING, ++dwCheckPoint);

        // Read config file
        CConfig oConfig;
        oConfig.Load();
        unsigned long ulServerPort = oConfig.GetServerPort();
        BOOL bLogMode = oConfig.GetLogMode();
        const char *pLogFile = oConfig.GetLogFile(); 

        ULONG ulLogMask = LOGMASK_BELPIC_ERROR;
#ifdef _DEBUG
        ulLogMask = LOGMASK_FULL;
#endif

        CLoggerManager *pLogManager = new CLoggerManager();
        if(pLogFile != NULL)
        {
            m_pLogfile = new CLoggerManagerModule_File();
		    m_pLogfile->SetFileName ((char *)pLogFile);
		    m_pLogfile->OpenFile();
		    pLogManager->AddModule (m_pLogfile);
		    if (bLogMode == (int)TRUE)
		    {
			    pLogManager->EnableModule ("File");
		    }
        }
		pLogManager->SetLogLevel (ulLogMask);

		pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "************************************************************");
        char strTitle[256] = {0};
        sprintf(strTitle, "**************** Belpic PC/SC Service %s ****************", EIDSERVICE_CURRENT_VERSION);
		pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, strTitle);
		pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, " Starting ...");

        SetServiceProgress(SERVICE_START_PENDING, ++dwCheckPoint);

		CConnectionManager *pConnectionManager = new CConnectionManager();
		pConnectionManager->SetConnectionType ("Mono");
		pConnectionManager->SetServerBasePort (ulServerPort);
		pConnectionManager->SetMaxServerConnection (30);
		pConnectionManager->StartServer ();
		pConnectionManager->Start();

        if(pLogManager != NULL)
        {
	        pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "ConnectionManager Started.");
        }

		SetServiceProgress(SERVICE_START_PENDING, ++dwCheckPoint);

        m_pPCSCManager = new CPCSCManager();
        m_pPCSCManager->Initialize();
        if(pLogManager != NULL)
        {
	        pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "PCSCManager Started.");
        }

        m_pApplicationManager = new CApplicationManager();
        if(pLogManager != NULL)
        {
	        pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "ApplicationManager Started.");
        }
        m_pCardChangeMonitor = new CCardChangeMonitor();
        m_pCardChangeMonitor->SetPCSCManager(m_pPCSCManager);
        m_pCardChangeMonitor->Start();
        if(pLogManager != NULL)
        {
	        pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "CardChangeMonitor Started.");
        }
        
		SetServiceProgress(SERVICE_START_PENDING, ++dwCheckPoint);

        if(oConfig.GetCRLSchedule())
        {
            m_pCRLScheduler = new CCRLScheduler();
            m_pCRLScheduler->Start();
            if(pLogManager != NULL)
            {
	            pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "CRLScheduler Started.");
            }        
        }

        SetServiceProgress(SERVICE_START_PENDING, ++dwCheckPoint);

		pLogManager->Log (__FILE__,__LINE__, LOGMASK_FULL, " Belpic PC/SC Service Started");
		pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "************************************************************");
		
        SetServiceProgress(SERVICE_RUNNING, 0);
}

void MyApp::MainStop()
{
    DWORD dwCheckPoint = 0;
    ULONG ulCounter;
    ulCounter = 0;

    SetServiceProgress(SERVICE_STOP_PENDING, ++dwCheckPoint);

    CMasterManager *pMasterManager = CMasterManager::Instance();
	CObjectManager *pObjectManager = PASS_GET_OBJECTMANAGER;

    CLoggerManager *pLogManager = (CLoggerManager *)pMasterManager->GetManager("Logger");
    if(pLogManager != NULL)
    {
	    pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL,"************************************************************");
	    pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL," Stopping ...");
    }

    if(m_pCRLScheduler != NULL)
    {
	    m_pCRLScheduler->Stop();
#ifdef _WIN32
	    while (m_pCRLScheduler->CanBeDeleted() == FALSE && ulCounter < 500)
	    {
		    PASS_MILLISLEEP (10);
		    ulCounter++;
	    }

	    if (ulCounter == 500)
	    {
		    // Reached timeout
		    // Kill handler
		    m_pCRLScheduler->Kill();
	    }
#else
	    m_pCRLScheduler->Kill();
#endif
	    delete m_pCRLScheduler;
	    m_pCRLScheduler = NULL;
        if(pLogManager != NULL)
        {
	        pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "CRL Scheduler Stopped.");
        }
    }   

    SetServiceProgress(SERVICE_STOP_PENDING, ++dwCheckPoint);

    ulCounter = 0;
    if(m_pCardChangeMonitor != NULL)
    {
	    m_pCardChangeMonitor->Stop();

	    while (m_pCardChangeMonitor->CanBeDeleted() == FALSE && ulCounter < 500)
	    {
		    PASS_MILLISLEEP (10);
		    ulCounter++;
	    }

	    if (ulCounter == 500)
	    {
		    // Reached timeout
		    // Kill handler
		    m_pCardChangeMonitor->Kill();
	    }

	    delete m_pCardChangeMonitor;
	    m_pCardChangeMonitor = NULL;
        if(pLogManager != NULL)
        {
	        pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "CardChangeMonitor Stopped.");
        }
    }

    SetServiceProgress(SERVICE_STOP_PENDING, ++dwCheckPoint);

    if(m_pApplicationManager != NULL)
    {
        delete m_pApplicationManager;
        m_pApplicationManager = NULL;
        if(pLogManager != NULL)
        {
	        pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "ApplicationManager Stopped.");
        }
    }

    if(m_pPCSCManager != NULL)
    {
        delete m_pPCSCManager;
        m_pPCSCManager = NULL;
        if(pLogManager != NULL)
        {
	        pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "PCSCManager Stopped.");
        }
    }

    ulCounter = 0;
    CConnectionManager *pConnectionManager = (CConnectionManager *)pMasterManager->GetManager("Connection");
    if(pConnectionManager != NULL)
    {
	    pConnectionManager->Stop();

	    while (pConnectionManager->CanBeDeleted() == FALSE && ulCounter < 500)
	    {
		    PASS_MILLISLEEP (10);
		    ulCounter++;
	    }

	    if (ulCounter == 500)
	    {
		    // Reached timeout
		    // Kill handler
		    pConnectionManager->Kill();
	    }
	    delete pConnectionManager;
	    pConnectionManager = NULL;
        if(pLogManager != NULL)
        {
	        pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL, "ConnectionManager Stopped.");
        }
    }

    SetServiceProgress(SERVICE_STOP_PENDING, ++dwCheckPoint);

    if(pLogManager != NULL)
    {
	    pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL," Belpic PC/SC Service Stopped");
	    pLogManager->Log (__FILE__, __LINE__, LOGMASK_FULL,"************************************************************");

	    delete pLogManager;
	    pLogManager = NULL;

        if (m_pLogfile != NULL)
	    {
		    delete m_pLogfile;
		    m_pLogfile = NULL;
	    }
    }

    delete m_pDefaultHandler;
    m_pDefaultHandler = NULL;
    delete m_pSCardHandler;
    m_pSCardHandler = NULL;

    PASS_MILLISLEEP(100);
    pMasterManager->RemoveAll();
    pObjectManager->RemoveAll();
 
    SetServiceProgress(SERVICE_STOPPED, 0);
}

void MyApp::SetServiceProgress(DWORD dwStatus, DWORD dwCheckPoint)
{
#ifdef _WIN32
	if(m_pServiceStarter != NULL)
	{
		m_pServiceStarter->ServiceSetStatus(dwStatus, dwCheckPoint);
	}
#endif
}
