/////////////////////////////////////////////////////////////////////////////
// Name:        wxmainapp.h
// Author:      XX
// Created:     XX/XX/XX
// Copyright:   
/////////////////////////////////////////////////////////////////////////////

#ifndef __wxMainApp_H__
#define __wxMainApp_H__

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// Include wxWindows' headers

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif


#include "StdAfx.h"
#include "defines.h"
#include "Config.h"
#ifdef _WIN32
    #include "ServiceStarter.h"
#endif
#include "PCSCManager.h"
#include "ApplicationManager.h"
#include "CardChangeMonitor.h"
#include "CRLScheduler.h"

#include "DefaultHandler.h"
#include "SCardHandler.h"


#ifdef _WIN32

//----------------------------------------------------------------------------
//   constants
//----------------------------------------------------------------------------

#define ID_QUIT     100

// WDR: class declarations

//----------------------------------------------------------------------------
// MyFrame
//----------------------------------------------------------------------------

class MyFrame: public wxFrame
{
public:
    // constructors and destructors
    MyFrame( wxWindow *parent, wxWindowID id, const wxString &title,
        const wxPoint& pos = wxDefaultPosition,
        const wxSize& size = wxDefaultSize,
        long style = wxDEFAULT_FRAME_STYLE );
    
private:
    // WDR: method declarations for MyFrame
    
private:
    // WDR: member variable declarations for MyFrame
    
private:
    // WDR: handler declarations for MyFrame
    void OnQuit( wxCommandEvent &event );
    void OnCloseWindow( wxCloseEvent &event );
    
private:
    DECLARE_EVENT_TABLE()
};

#endif

//----------------------------------------------------------------------------
// MyApp
//----------------------------------------------------------------------------

#ifdef _WIN32
class MyApp: public wxApp
#else
class MyApp
#endif
{
public:
    MyApp();
    
    virtual bool OnInit();
    virtual int OnExit();
    CCardChangeMonitor *GetCardMonitor() { return m_pCardChangeMonitor;}
    BOOL GetHibernate() { return m_bHibernate; }

#ifndef _WIN32
    void AtExit();
    static void SignalHandler(int iSigNr);
    static MyApp *m_pApp;
#endif

private:
    void MainStart();
    void MainStop();
    void SetServiceProgress(DWORD dwStatus, DWORD dwCheckPoint);

#ifndef _WIN32
    void Daemon();
#endif

// Members
protected:

private:
#ifdef _WIN32
    ServiceStarter *m_pServiceStarter;
#else
    int m_FileLock;
#endif
    CLoggerManagerModule_File *m_pLogfile;
    CPCSCManager *m_pPCSCManager;
    CApplicationManager *m_pApplicationManager;
    CCardChangeMonitor *m_pCardChangeMonitor;
    CCRLScheduler *m_pCRLScheduler;
    CDefaultHandler *m_pDefaultHandler;
    CSCardHandler *m_pSCardHandler;
    BOOL m_bHibernate;
};

#endif
