// AutoUpdate.cpp: implementation of the CAutoUpdate class.
//
//////////////////////////////////////////////////////////////////////

/******************************************
 Change these consts for a new release
******************************************/
#ifdef _WIN32
    #define EIDLIB_CURRENT_VERSION "2.3.13"
    #pragma message( "*** Current version is " EIDLIB_CURRENT_VERSION " ***") 
#endif
#ifdef linux
    #define EIDLIB_CURRENT_VERSION "2.3.13"
#endif

#include "BEIDApp.h"
#include "AutoUpdate.h"
#include "Config.h"
#include "Verify.h"

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

#include <wx/datetime.h>
#include <wx/confbase.h>
#include <wx/fileconf.h>
#include <wx/filename.h>
#include <wx/mimetype.h> // mimetype support

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAutoUpdate::CAutoUpdate(wxThreadKind kind) : wxThread(kind)
{
    m_bAlreadyAsked = false;
}

CAutoUpdate::~CAutoUpdate()
{

}

void *CAutoUpdate::Entry()
{
    if(eidlib::CConfig::AllowAutoUpdate() )
    {
        bool bDoCheck = false;
        wxDateTime dtnow = wxDateTime::Now();
        wxString strDateTime = dtnow.Format("%Y%m%d%H%M%S");
        const char *pszLastCheck = eidlib::CConfig::GetAutoUpdateLastCheck();
        if(pszLastCheck == NULL)
        {
            // First time
            bDoCheck = true;
        }
        else
        {
            int iDays = eidlib::CConfig::GetAutoUpdateScheduleDays();  
            if(iDays > 0)
            {
                wxDateTime dtCheck;
                dtCheck.ParseFormat(pszLastCheck, "%Y%m%d%H%M%S");
                dtCheck.Add(wxDateSpan::Days(iDays));
                bDoCheck = dtnow.IsLaterThan(dtCheck);
            }
        }

#ifdef _DEBUG
        // bDoCheck = true;
#endif
        if(bDoCheck)
        {
            void  *pvData = 0;
            int  iDataLen = 0;
            char *pszUri = (char *)eidlib::CConfig::GetAutoUpdateVersionURL(); 
            if (NULL != (pvData = CVerify::RetrieveData(pszUri, &iDataLen)))
            {
                ParseVersionFile(pvData, iDataLen, m_oVersion);
#ifdef _WIN32
                if (stricmp (EIDLIB_CURRENT_VERSION, m_oVersion.GetVersion()) < 0) 
#else
                if (strcasecmp (EIDLIB_CURRENT_VERSION, m_oVersion.GetVersion()) < 0) 
#endif
                {
#ifdef _WIN32
                    RetrieveNewVersion(false);
#else
                    CBEIDApp::SetDownload(TRUE);
#endif
                }
                eidlib::CConfig::UpdateLastCheck((char *)strDateTime.c_str()); 
            }

        }
    }
    return NULL;
}

void CAutoUpdate::OnExit()
{
}


void CAutoUpdate::ParseVersionFile (void *pszVersionFile, int iLen, CVersionInfo & oVersion)
{
	/*
		The format for the version file is as such:

		<---- Start Of File ---->
        [Windows] 
        version=2.11.06 
        url=http://belgium.be/eid/eidlib/download.html#windows 

        [Linux] 
        version=2.11.32 
        url=http://belgium.be/eid/eidlib/linux.html 

        [MacOs] 
        ... 
		<----  End Of File  ---->
	*/    

    wxFile oSaveFile;
    wxString strFileName = wxFileName::CreateTempFileName("ver", &oSaveFile);
    oSaveFile.Write(pszVersionFile, iLen);
    oSaveFile.Close();
    wxFileConfig oConfig(wxT(""), wxT(""), strFileName, wxT(""), wxCONFIG_USE_GLOBAL_FILE);

    wxString str;
    wxString strKey;
    wxString strName;
#ifdef _WIN32
    strKey = "Windows";
#else
    strKey = "Linux";
#endif

    strName = strKey + wxT("/version");
    if ( oConfig.Read(strName, &str) ) 
    {
        str.Trim();
        if(!str.IsEmpty())
        {
            oVersion.SetVersion(str); 
        }
    }
    strName = strKey + wxT("/url");
    if ( oConfig.Read(strName, &str) ) 
    {
        str.Trim();
        if(!str.IsEmpty())
        {
            oVersion.SetDownloadUrl(str); 
        }
    }

    oConfig.Flush();

    ::wxRemoveFile(strFileName);
}

void CAutoUpdate::RetrieveNewVersion (bool bNewCard /* false */)
{
    wxCriticalSectionLocker lock(m_cs);
    if(!eidlib::CConfig::AllowAutoUpdate() || m_bAlreadyAsked)
    {
        return;
    }
    wxString strMessage = wxEmptyString;
    if(bNewCard)
    {
        // Check if version info file already downloaded
        if(m_oVersion.GetDownloadUrl().IsEmpty() )
        {
            // Not yet so download
            void  *pvData = 0;
            int  iDataLen = 0;
            char *pszUri = (char *)eidlib::CConfig::GetAutoUpdateVersionURL(); 
            if (NULL != (pvData = CVerify::RetrieveData(pszUri, &iDataLen)))
            {
                ParseVersionFile(pvData, iDataLen, m_oVersion);
            }
            else
            {
                // Download failed, useless to ask for update
                return;
            }
        }
        strMessage = _("The software does not know about this card version.\nDo you want to download the latest version of the software ?");
    }
    else
    {
        strMessage = _("A newer version of the software is available.\nDo you want to download it ?");
    }
    if(wxYES == CBEIDApp::AskDownload (strMessage)) 
    {
        ExecuteLink(m_oVersion.GetDownloadUrl());
    }
    m_bAlreadyAsked = true;
}

void CAutoUpdate::ExecuteLink (const wxString &link) 
{
    wxString mimetype = wxEmptyString;
    if (link.StartsWith (_T("http://"))) 
    {
        mimetype = _T("text/html");
    }
    else if (link.StartsWith (_T("https://"))) 
    {
        mimetype = _T("text/html");
    }    
    else if (link.StartsWith (_T("ftp://"))) 
    {
        mimetype = _T("text/html");
    }
    else if (link.StartsWith (_T("mailto:"))) 
    {
        mimetype = _T("message/rfc822");
    }
    else
    {
        return;
    }

    wxFileType *filetype = wxTheMimeTypesManager->GetFileTypeFromExtension(wxT("html"));
    if(NULL == filetype)
    {
        filetype = wxTheMimeTypesManager->GetFileTypeFromMimeType (mimetype);
    }

    if (filetype) 
    {
        wxString cmd;
        if (filetype->GetOpenCommand (&cmd, wxFileType::MessageParameters (link))) 
        {
            cmd.Replace(_T("file://"), wxEmptyString);
            ::wxExecute(cmd);
        }
        delete filetype;
    }
}
