/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_GetSessionInfo()
{
	int errors = 0;
	CK_SLOT_ID slotID1;
	CK_SESSION_HANDLE session;
	CK_FLAGS flags = CKF_SERIAL_SESSION;
	CK_SESSION_INFO info;

	printf("C_GetSessionInfo\n");

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	if (p11->C_GetSessionInfo(12345, &info) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_GetSessionInfo(1) didn't return CKR_SESSION_HANDLE_INVALIDn");
		errors++;
	}

	slotID1 = getFirstSlot(1);

	if (p11->C_OpenSession(slotID1, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &session) != CKR_OK) {
		printf("    ERR: C_OpenSession(2) didn't return CKR_OK\n");
		errors++;
	}

	if (p11->C_GetSessionInfo(session, NULL_PTR) != CKR_ARGUMENTS_BAD) {
		printf("    ERR: C_GetSessionInfo(2) didn't return CKR_ARGUMENTS_BAD\n");
		errors++;
	}

	if (p11->C_GetSessionInfo(session, &info) != CKR_OK) {
		printf("    ERR: C_GetSessionInfo(3) didn't return CKR_OK\n");
		errors++;
	}
	if (info.slotID != slotID1) {
		printf("    ERR: session slotID is wrong\n");
		errors++;
	}
	if (info.state != CKS_RO_PUBLIC_SESSION) {
		printf("    ERR: session state not equal to CKS_RO_PUBLIC_SESSION\n");
		errors++;
	}
	if (info.flags & CKF_SERIAL_SESSION == 0) {
		printf("    ERR: session flag CKF_SERIAL_SESSION not set\n");
		errors++;
	}

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_GetSessionInfo(session, &info) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_GetSessionInfo(4) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}

