/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_GetSlotInfo()
{
	int errors = 0;
	CK_SLOT_ID slotID1, slotID2;
	CK_SLOT_INFO slotInfo;

	printf("C_GetSlotInfo\n");

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	slotID1 = getFirstSlot(1);

	if (p11->C_GetSlotInfo(slotID1, NULL_PTR) != CKR_ARGUMENTS_BAD) {
		printf("    C_GetSlotInfo(1) didn't return CKR_ARGUMENTS_BAD\n");
		errors++;
	}

	if (p11->C_GetSlotInfo(12345, &slotInfo) != CKR_SLOT_ID_INVALID) {
		printf("    C_GetSlotInfo(2) didn't return CKR_SLOT_ID_INVALID\n");
		errors++;
	}

	if (p11->C_GetSlotInfo(slotID1, &slotInfo) != CKR_OK) {
		printf("    C_GetSlotInfo(3) didn't return CKR_OK\n");
		errors++;
	}
	if (!(slotInfo.flags & CKF_TOKEN_PRESENT)) {
		printf("    C_GetSlotInfo(3): CKF_TOKEN_PRESENT flag not set\n");
		errors++;
	}
	if (!(slotInfo.flags & CKF_REMOVABLE_DEVICE)) {
		printf("    C_GetSlotInfo(3): CKF_REMOVABLE_DEVICE flag not set\n");
		errors++;
	}
	if (!(slotInfo.flags & CKF_HW_SLOT)) {
		printf("    C_GetSlotInfo(3): CKF_HW_SLOT flag not set\n");
		errors++;
	}

	slotID2 = getFirstSlot(0);
	if (p11->C_GetSlotInfo(slotID2, &slotInfo) != CKR_OK) {
		printf("    C_GetSlotInfo(3) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_GetSlotInfo(slotID2, &slotInfo) != CKR_OK) {
		printf("    C_GetSlotInfo(3) didn't return CKR_OK\n");
		errors++;
	}
	if (!(slotInfo.flags & CKF_REMOVABLE_DEVICE)) {
		printf("    C_GetSlotInfo(3): CKF_REMOVABLE_DEVICE flag not set\n");
		errors++;
	}
	if (!(slotInfo.flags & CKF_HW_SLOT)) {
		printf("    C_GetSlotInfo(3): CKF_HW_SLOT flag not set\n");
		errors++;
	}

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_GetSlotInfo(slotID1, &slotInfo) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    C_GetSlotInfo(4) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}
