/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_Initialize()
{
	CK_C_INITIALIZE_ARGS init_args = {NULL, NULL, NULL, NULL, 0, NULL};
	int errors = 0, a = 0;

	printf("C_Initialize\n");

	printf("  Cat 1\n");
	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize() didn't return CKR_OK\n");
		return ++errors;
	}

	printf("  Cat 2\n");
	if (p11->C_Initialize(&init_args) != CKR_OK) {
		printf("    ERR: C_Initialize(1) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(1) didn't return CKR_OK\n");
		return ++errors;
	}

	init_args.flags = CKF_OS_LOCKING_OK;
	if (p11->C_Initialize(&init_args) != CKR_OK) {
		printf("    ERR: C_Initialize(2) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(2) didn't return CKR_OK\n");
		return ++errors;
	}

	init_args.flags = 0;
	init_args.pReserved = &a;
	if (p11->C_Initialize(&init_args) != CKR_ARGUMENTS_BAD) {
		printf("    ERR: C_Initialize(3) didn't return CKR_ARGUMENTS_BAD\n");
		errors++;
	}
	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(3) didn't return CKR_OK\n");
		return ++errors;
	}

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    C_Initialize(4) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_Initialize(NULL_PTR) != CKR_CRYPTOKI_ALREADY_INITIALIZED) {
		printf("    ERR: C_Initialize(4) didn't return CKR_CRYPTOKI_ALREADY_INITIALIZED\n");
		errors++;
	}
	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(4) didn't return CKR_OK\n");
		return ++errors;
	}

	return errors;
}
