/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"


int c_SignUpdateFinal()
{
	char *pin = "1234";
	CK_ULONG pinLen = (pin == NULL_PTR ? 0 : strlen(pin));

	int errors = 0;
	CK_SESSION_HANDLE session, session2;
	CK_OBJECT_HANDLE key;
	CK_MECHANISM mech = {CKM_SHA1_RSA_PKCS, NULL, 0};
	CK_BYTE buf[128];
	CK_ULONG bufLen = sizeof(buf);
	CK_BYTE sig[128];
	CK_ULONG sigLen = sizeof(sig);
	CK_BYTE sig1[128];
	CK_ULONG sigLen1 = sizeof(sig1);
	CK_RV rv;

	printf("C_SignUpdate and C_SignFinal\n");

	printf("  Cat 1\n");

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	/* test 1 */
	if (p11->C_SignUpdate(12345, buf, bufLen) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_SignUpdate(1) didn't return CKR_SESSION_HANDLE_INVALID\n");
		errors++;
	}
	if (p11->C_SignFinal(12345, buf, &bufLen) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_SignFinal(1) didn't return CKR_SESSION_HANDLE_INVALID\n");
		errors++;
	}

	/* test 2 */

	session = getSessionInFirstSlot();
	session2 = getSessionInFirstSlot();

	if (p11->C_SignUpdate(session, buf, bufLen) != CKR_OPERATION_NOT_INITIALIZED) {
		printf("    ERR: C_SignUpdate(2) didn't return CKR_OPERATION_NOT_INITIALIZED\n");
		errors++;
	}
	if (p11->C_SignFinal(session, buf, &bufLen) != CKR_OPERATION_NOT_INITIALIZED) {
		printf("    ERR: C_SignFinal(2) didn't return CKR_OPERATION_NOT_INITIALIZED\n");
		errors++;
	}

	/* test 3 */

	rv = p11->C_Login(session, CKU_USER, pin, pinLen);
	if (rv  != CKR_OK) {
		printf("    ERR: C_Login(2) didn't return CKR_OK but %s\n", CKR2Str(rv));
		exit(++errors);
	}

	key = find_object(session, CKO_PRIVATE_KEY, 0);

	if (p11->C_SignInit(session, &mech, key) != CKR_OK) {
		printf("    ERR: C_SignUpdate(2) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_SignUpdate(session, buf, bufLen) != CKR_OK) {
		printf("    ERR: C_SignUpdate(2) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_SignFinal(session, sig, &sigLen) != CKR_OK) {
		printf("    ERR: C_SignFinal(2) didn't return CKR_OK\n");
		errors++;
	}

	/* test 4 */
	rv = p11->C_CloseSession(session);
	if (rv  != CKR_OK) {
		printf("    ERR: C_CloseSession(4) didn't return CKR_OK but %s\n", CKR2Str(rv));
		exit(++errors);
	}
	if (p11->C_SignUpdate(12345, buf, bufLen) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_SignUpdate(4) didn't return CKR_SESSION_HANDLE_INVALID\n");
		errors++;
	}
	if (p11->C_SignFinal(12345, buf, &bufLen) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_SignFinal(4) didn't return CKR_SESSION_HANDLE_INVALID\n");
		errors++;
	}

	printf("  Cat 2\n");

	/* test1 */

	session = session2;
	key = find_object(session, CKO_PRIVATE_KEY, 0);

	if (p11->C_SignInit(session, &mech, key) != CKR_OK) {
		printf("    ERR: C_SignUpdate(1) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_SignUpdate(session, buf, 5) != CKR_OK) {
		printf("    ERR: C_SignUpdate(1) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_SignUpdate(session, buf+5, 50) != CKR_OK) {
		printf("    ERR: C_SignUpdate(1) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_SignUpdate(session, buf+55, bufLen-55) != CKR_OK) {
		printf("    ERR: C_SignUpdate(1) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_SignFinal(session, sig, &sigLen) != CKR_OK) {
		printf("    ERR: C_SignFinal(1) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_SignInit(session, &mech, key) != CKR_OK) {
		printf("    ERR: C_SignUpdate(1) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_Sign(session, buf, bufLen, sig1, &sigLen1) != CKR_OK) {
		printf("    ERR: C_SignUpdate(1) didn't return CKR_OK\n");
		errors++;
	}
	if (sigLen != sigLen1 || memcmp(sig, sig1, sigLen) != 0) {
		printf("    ERR: Differents results for test 1\n");
		errors++;
	}

	/* test2 */

	if (p11->C_SignInit(session, &mech, key) != CKR_OK) {
		printf("    ERR: C_SignUpdate(2) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_SignUpdate(session, buf, 5) != CKR_OK) {
		printf("    ERR: C_SignUpdate(2) didn't return CKR_OK\n");
		errors++;
	}
	sigLen = 127;
	if (p11->C_SignFinal(session, sig, &sigLen) != CKR_BUFFER_TOO_SMALL) {
		printf("    ERR: C_SignFinal(2) didn't return CKR_BUFFER_TOO_SMALL\n");
		errors++;
	}
	sigLen = 0;
	if (p11->C_SignFinal(session, NULL_PTR, &sigLen) != CKR_OK) {
		printf("    ERR: C_SignFinal(2) didn't return CKR_OK\n");
		errors++;
	}

	/* test3 */

	if (sigLen != 128) {
		printf("    ERR: C_SignFinal(2) returned %d for the signature length\n", sigLen);
		errors++;
	}

	/* test4 */

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_SignUpdate(session, buf, bufLen) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_SignUpdate(1) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}
	if (p11->C_SignFinal(session, sig, &sigLen) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_SignFinal(1) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}
