/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_WaitForSlotEvent()
{
	int errors = 0;
	CK_SLOT_ID slotID;
	int a;

	printf("C_WaitForSlotEvent\n");

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	if (p11->C_WaitForSlotEvent(CKF_DONT_BLOCK, &slotID, NULL_PTR) != CKR_NO_EVENT) {
		printf("    C_WaitForSlotEvent(1) didn't return CKR_NO_EVENTS\n");
		errors++;
	}

	if (p11->C_WaitForSlotEvent(CKF_DONT_BLOCK, &slotID, &a) != CKR_ARGUMENTS_BAD) {
		printf("    C_WaitForSlotEvent(2) didn't return CKR_ARGUMENTS_BAD\n");
		errors++;
	}

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_WaitForSlotEvent(CKF_DONT_BLOCK, &slotID, NULL_PTR) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    C_WaitForSlotEvent(3) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}
