/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

void *module = NULL;
CK_FUNCTION_LIST_PTR p11 = NULL;

const struct option options[] = { 0, 0, 0, 0 };
const char *option_help[] = {NULL};
const char *app_name = "pkcs11-functions";

int
main(int argc, char * const argv[])
{
	int errors = 0;
	int testNr;
	int iterations = 1;

	if (argc < 2) {
		printf("Usage: pkcs11-lowlevel <testnumber> {<iterations>}\n");
		printf("       default number of iterations = 1\n");
		return 0;
	}

	testNr = atoi(argv[1]);
	if (testNr == 0 && argv[1][0] != '0') {
		printf("Testnumber should be an integer\n");
		exit(-1);
	}
	if (testNr < 1 && testNr > N_TESTS) {
		printf("Only testnumbers between 0 and %d are allowed\n", N_TESTS);
		exit(-1);
	}

	if (argc > 2) {
		iterations = atoi(argv[2]);
		if (iterations == 0) {
			printf("iterations should be an integer and different from 0\n");
			exit(-1);
		}
	}

	//printf("pkcs11 low level tests\n");
	//printf("======================\n");

	module = C_LoadModule(P11_LIB_NAME, &p11);
	if (module == NULL) {
		printf("Failed to load pkcs11 module %s, exiting\n", P11_LIB_NAME);
		exit(-1);
	}

	while(iterations > 0) {
		if (testNr == 1  || !testNr) errors += c_Initialize();
		if (testNr == 2  || !testNr) errors += c_Finalize();
		if (testNr == 3  || !testNr) errors += c_GetInfo();
		if (testNr == 4  || !testNr) errors += c_GetFunctionList();
		if (testNr == 5  || !testNr) errors += c_GetSlotList();
		if (testNr == 6  || !testNr) errors += c_GetSlotInfo();
		if (testNr == 7  || !testNr) errors += c_GetTokenInfo();
		if (testNr == 8  || !testNr) errors += c_GetMechanismList();
		if (testNr == 9  || !testNr) errors += c_GetMechanismInfo();
		if (testNr == 10 || !testNr) errors += c_WaitForSlotEvent();
		if (testNr == 11 || !testNr) errors += c_OpenSession();
		if (testNr == 12 || !testNr) errors += c_CloseSession();
		if (testNr == 13 || !testNr) errors += c_CloseAllSessions();
		if (testNr == 14 || !testNr) errors += c_GetSessionInfo();
		if (testNr == 15 || !testNr) errors += c_FindObjectsInit();
		if (testNr == 16 || !testNr) errors += c_FindObjects();
		if (testNr == 17 || !testNr) errors += c_FindObjectsFinal();
		if (testNr == 18 || !testNr) errors += c_GetAttributeValue();
		if (testNr == 19 || !testNr) errors += c_DigestInit();
		if (testNr == 20 || !testNr) errors += c_Digest();
		if (testNr == 21 || !testNr) errors += c_DigestUpdateFinal();
		if (testNr == 22 || !testNr) errors += c_SeedRandom();
		if (testNr == 23 || !testNr) errors += c_GenerateRandom();
		if (testNr == 24 || !testNr) errors += c_SetPin();

		if (testNr == 25 || !testNr) errors += c_Login();
		if (testNr == 26 || !testNr) errors += c_Logout();
		if (testNr == 27 || !testNr) errors += c_SignInit();
		if (testNr == 28 || !testNr) errors += c_Sign();
		if (testNr == 29 || !testNr) errors += c_SignUpdateFinal();
		if (testNr == 30) errors += c_SetPin_PP();
		if (testNr == 31) errors += c_Login_PP();

		iterations--;
	}

	if (C_UnloadModule(module) != CKR_OK) {
		printf("Failed to unload pkcs11 module %s\n", P11_LIB_NAME);
		exit(-1);
	}

	if (errors != 0)
		printf("\n==> %d errors\n", errors);
	else
		printf("\n==> OK\n");

	return errors;
}
