/*
 *
 * Beryl hardware/software detection system
 *
 * Copyright : (C) 2006 by Quinn Storm
 * E-mail    : quinn@beryl-project.org
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <beryl-settings.h>

extern char *     programName;
extern char       **programArgv;
extern int        programArgc;

extern Window     currentRoot;
extern Bool       restartSignal;
extern CompWindow *lastFoundWindow;
extern CompWindow *lastDamagedWindow;
extern Bool       replaceCurrentWm;
extern Bool       indirectRendering;
extern Bool       strictBinding;
extern Bool       useCow;
extern Bool		  copyTexture;
extern Bool		  noShm;
extern Bool       skipTests;
extern Bool       nvidia;
extern Bool       disable_vsync;
extern Bool       noContextShare;

extern int  defaultRefreshRate;
extern char *defaultTextureFilter;

#define SHM_SIZE 4096*2048*4

extern CompDisplay *compDisplays;

extern ScreenPaintAttrib defaultScreenPaintAttrib;
extern WindowPaintAttrib defaultWindowPaintAttrib;

extern REGION infiniteRegion;
extern REGION emptyRegion;

extern void updatePlugins (CompDisplay *d);
extern void releaseDisplay(void);
extern void compDisplayFreeOptions(CompDisplay *display);
extern void releaseScreen(CompScreen *screen);
extern void compFreeScreenOptions(CompScreen *screen);
extern void finiPlugins(CompDisplay *d);
extern void reload_setting(BerylSettingsContext *c);
