/*
 * Copyright © 2005 Novell, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Author: David Reveman <davidr@novell.com>
 */

#include <stdlib.h>

#include <beryl.h>
#include <beryl-private.h>

int
allocatePrivateIndex(int *len,
					 char **indices,
					 ReallocPrivatesProc reallocProc, void *closure)
{
	char *newIndices;
	int i;

	for (i = 0; i < *len; i++)
	{
		if (!(*indices)[i])
		{
			(*indices)[i] = 1;
			return i;
		}
	}

	newIndices = (char *)realloc(*indices, (*len + 1) * sizeof(char));
	if (!newIndices)
		return -1;

	newIndices[*len] = 1;
	*indices = newIndices;

	if (!(*reallocProc) (*len + 1, closure))
		return -1;

	return (*len)++;
}

void freePrivateIndex(int len, char *indices, int index)
{
	if (index < len)
		indices[index] = 0;
}
