/*
 * Copyright © Novell, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Author: David Reveman <davidr@novell.com>
 * Reorganised by Quinn_Storm
 */
#ifdef HAVE_CONFIG_H
#  include "../config.h"
#endif

#include <string.h>

#include <beryl.h>
#include "beryl-private.h"

#define DETECT_REFRESH_RATE_DEFAULT TRUE
#define LEGACY_MAXIMIZE_DEFAULT FALSE

#define SCREEN_HSIZE_DEFAULT  4
#define SCREEN_HSIZE_MIN      1
#define SCREEN_HSIZE_MAX     16

#define SCREEN_VSIZE_DEFAULT 1
#define SCREEN_VSIZE_MIN     1
#define SCREEN_VSIZE_MAX     16

#define LIGHTING_DEFAULT FALSE

#define OPACITY_STEP_DEFAULT 10
#define OPACITY_STEP_MIN     1
#define OPACITY_STEP_MAX     50

#define SATURATION_STEP_DEFAULT   5
#define SATURATION_STEP_MAX       10
#define SATURATION_STEP_MIN       1

#define BRIGHTNESS_STEP_DEFAULT   5
#define BRIGHTNESS_STEP_MAX       10
#define BRIGHTNESS_STEP_MIN       1

#define UNREDIRECT_FS_DEFAULT FALSE

#define DEFAULT_ICON_DEFAULT "icon"

#define SYNC_TO_VBLANK_DEFAULT TRUE

#define SCREEN_NUMBER_OF_DESKTOPS_DEFAULT 1
#define SCREEN_NUMBER_OF_DESKTOPS_MIN     1
#define SCREEN_NUMBER_OF_DESKTOPS_MAX     MAXSHORT

#define DEFAULT_REFRESH_RATE 60

#ifndef NUM_OPTIONS
#define NUM_OPTIONS(s) (sizeof ((s)->opt) / sizeof (CompOption))
#endif

void compScreenInitOptions(CompScreen * screen);

void compFreeScreenOptions(CompScreen * screen)
{
}

void compScreenInitOptions(CompScreen * screen)
{
	CompOption *o;

	o = &screen->opt[COMP_SCREEN_OPTION_DETECT_REFRESH_RATE];
	o->advanced = False;
	o->name = "detect_refresh_rate";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Detect Refresh Rate");
	o->longDesc = N_("Automatic detection of refresh rate");
	o->type = CompOptionTypeBool;
	o->value.b = DETECT_REFRESH_RATE_DEFAULT;

	o = &screen->opt[COMP_SCREEN_OPTION_LEGACY_MAXIMIZE_FIX];
	o->advanced = False;
	o->name = "legacy_maximize_fix";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Enable workarounds for certain Wine and legacy"
					  " windows");
	o->longDesc = N_("This will mask certain windows as maximized based "
					 "on their inital size settings. This helps on certain"
					 " Wine and legacy windows, but can create unwanted "
					 "behavior in other things, such as OpenOffice and "
					 "similar. ");
	o->type = CompOptionTypeBool;
	o->advanced = True;
	o->value.b = LEGACY_MAXIMIZE_DEFAULT;

	o = &screen->opt[COMP_SCREEN_OPTION_LIGHTING];
	o->advanced = False;
	o->name = "lighting";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Lighting");
	o->longDesc = N_("Use diffuse light when screen is transformed");
	o->type = CompOptionTypeBool;
	o->value.b = LIGHTING_DEFAULT;

	o = &screen->opt[COMP_SCREEN_OPTION_REFRESH_RATE];
	o->advanced = False;
	o->name = "refresh_rate";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Refresh Rate");
	o->longDesc =
			N_("The rate at which the screen is redrawn (times/second)");
	o->type = CompOptionTypeInt;
	o->value.i = DEFAULT_REFRESH_RATE;
	o->rest.i.min = 1;
	o->rest.i.max = 200;

	o = &screen->opt[COMP_SCREEN_OPTION_HSIZE];
	o->advanced = False;
	o->name = "size";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Horizontal Virtual Size");
	o->longDesc = N_("Screen size multiplier for virtual size");
	o->type = CompOptionTypeInt;
	o->value.i = SCREEN_HSIZE_DEFAULT;
	o->rest.i.min = SCREEN_HSIZE_MIN;
	o->rest.i.max = SCREEN_HSIZE_MAX;

	o = &(screen->opt[COMP_SCREEN_OPTION_VSIZE]);
	o->advanced = False;
	o->name = "vsize";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Vertical Virtual Size");
	o->longDesc = N_("Screen size multiplier for vertical virtual size");
	o->type = CompOptionTypeInt;
	o->value.i = SCREEN_VSIZE_DEFAULT;
	o->rest.i.min = SCREEN_VSIZE_MIN;
	o->rest.i.max = SCREEN_VSIZE_MAX;

	o = &screen->opt[COMP_SCREEN_OPTION_OPACITY_STEP];
	o->advanced = True;
	o->name = "opacity_step";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Opacity Step");
	o->longDesc = N_("Opacity change step");
	o->type = CompOptionTypeInt;
	o->value.i = OPACITY_STEP_DEFAULT;
	o->rest.i.min = OPACITY_STEP_MIN;
	o->rest.i.max = OPACITY_STEP_MAX;

	o = &screen->opt[COMP_SCREEN_OPTION_SATURATION_STEP];
	o->advanced = True;
	o->name = "saturation_step";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Saturation Step");
	o->longDesc = N_("Saturation change step");
	o->type = CompOptionTypeInt;
	o->value.i = SATURATION_STEP_DEFAULT;
	o->rest.i.min = SATURATION_STEP_MIN;
	o->rest.i.max = SATURATION_STEP_MAX;

	o = &screen->opt[COMP_SCREEN_OPTION_BRIGHTNESS_STEP];
	o->advanced = True;
	o->name = "brightness_step";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Brightness Step");
	o->longDesc = N_("Brightness change step");
	o->type = CompOptionTypeInt;
	o->value.i = BRIGHTNESS_STEP_DEFAULT;
	o->rest.i.min = BRIGHTNESS_STEP_MIN;
	o->rest.i.max = BRIGHTNESS_STEP_MAX;

	o = &screen->opt[COMP_SCREEN_OPTION_UNREDIRECT_FS];
	o->advanced = True;
	o->name = "unredirect_fullscreen_windows";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Unredirect Fullscreen Windows");
	o->longDesc =
			N_("Allow drawing of fullscreen windows to not be redirected "
			   "to offscreen pixmaps");
	o->type = CompOptionTypeBool;
	o->value.b = UNREDIRECT_FS_DEFAULT;

	o = &screen->opt[COMP_SCREEN_OPTION_DEFAULT_ICON];
	o->advanced = False;
	o->name = "default_icon";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "file;image;";
	o->shortDesc = N_("Default Icon");
	o->longDesc = N_("Default window icon image");
	o->type = CompOptionTypeString;
	o->value.s = strdup(DEFAULT_ICON_DEFAULT);
	o->rest.s.string = 0;
	o->rest.s.nString = 0;

/*    o = &screen->opt[COMP_SCREEN_OPTION_SLOWNESS_FIX];
    o->advanced=False;
o->name = "slowness_fix";
    o->group=N_("");
o->subGroup=N_("");
o->displayHints="";
o->shortDesc = N_("Slowness Fix");
    o->longDesc = N_("Toggle this option if beryl is slow or choppy. "
                     "On some cards, enabling it makes beryl smoother, and on "
                     "others, disabling makes beryl smoother.");
    o->type = CompOptionTypeBool;
    o->value.b = TRUE;*/

	o = &screen->opt[COMP_SCREEN_OPTION_SYNC_TO_VBLANK];
	o->advanced = False;
	o->name = "sync_to_vblank";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Sync To VBlank");
	o->longDesc = N_("Only perform screen updates during vertical "
					 "blanking period");
	o->type = CompOptionTypeBool;
	o->value.b = SYNC_TO_VBLANK_DEFAULT;

	o = &screen->opt[COMP_SCREEN_OPTION_NUMBER_OF_DESKTOPS];
	o->advanced = False;
	o->name = "number_of_desktops";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Number of Desktops");
	o->longDesc = N_("Number of virtual desktops");
	o->type = CompOptionTypeInt;
	o->value.i = SCREEN_NUMBER_OF_DESKTOPS_DEFAULT;
	o->rest.i.min = SCREEN_NUMBER_OF_DESKTOPS_MIN;
	o->rest.i.max = SCREEN_NUMBER_OF_DESKTOPS_MAX;

	o = &screen->opt[COMP_SCREEN_OPTION_CUSTOM_OUTPUT_GRID];
	o->advanced = True;
	o->name = "custom_output_grid";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Custom Output Grid");
	o->longDesc = N_("Use custom output grid instead of Xinerama info.");
	o->type = CompOptionTypeBool;
	o->value.b = FALSE;

	o = &screen->opt[COMP_SCREEN_OPTION_OUTPUT_GRID_ROWS];
	o->advanced = True;
	o->name = "output_grid_rows";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Output grid rows");
	o->longDesc = N_("Number of rows in the custom output grid.");
	o->type = CompOptionTypeInt;
	o->value.i = 1;
	o->rest.i.min = 1;
	o->rest.i.max = 99;

	o = &screen->opt[COMP_SCREEN_OPTION_OUTPUT_GRID_COLS];
	o->advanced = True;
	o->name = "output_grid_cols";
	o->group = N_("Main");
	o->subGroup = N_("");
	o->displayHints = "";
	o->shortDesc = N_("Output grid columns");
	o->longDesc = N_("Number of columns in the custom output grid.");
	o->type = CompOptionTypeInt;
	o->value.i = 2;
	o->rest.i.min = 1;
	o->rest.i.max = 99;
}

CompOption *compGetScreenOptions(CompScreen * screen, int *count)
{
	*count = NUM_OPTIONS(screen);
	return screen->opt;
}

CompOption *compGetOptions(int *count)
{
	static CompScreen screen;

	compScreenInitOptions(&screen);
	return compGetScreenOptions(&screen, count);
}
