/*
 * Copyright © Novell, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Author: David Reveman <davidr@novell.com>
 * Reorganised by Quinn Storm <>
 *
 */

#define _GNU_SOURCE

#include <stdlib.h>
#include <string.h>
#include <strings.h>

#include <beryl.h>

unsigned int compWindowTypeMaskFromStringList(CompOptionValue * value)
{
	int i;
	unsigned int mask = 0;

	for (i = 0; i < value->list.nValue; i++)
	{
		if (strcasecmp(value->list.value[i].s, "desktop") == 0)
			mask |= CompWindowTypeDesktopMask;
		else if (strcasecmp(value->list.value[i].s, "dock") == 0)
			mask |= CompWindowTypeDockMask;
		else if (strcasecmp(value->list.value[i].s, "toolbar") == 0)
			mask |= CompWindowTypeToolbarMask;
		else if (strcasecmp(value->list.value[i].s, "menu") == 0)
			mask |= CompWindowTypeMenuMask;
		else if (strcasecmp(value->list.value[i].s, "utility") == 0)
			mask |= CompWindowTypeUtilMask;
		else if (strcasecmp(value->list.value[i].s, "splash") == 0)
			mask |= CompWindowTypeSplashMask;
		else if (strcasecmp(value->list.value[i].s, "dialog") == 0)
			mask |= CompWindowTypeDialogMask;
		else if (strcasecmp(value->list.value[i].s, "normal") == 0)
			mask |= CompWindowTypeNormalMask;
		else if (strcasecmp(value->list.value[i].s, "dropdownmenu") == 0)
			mask |= CompWindowTypeDropdownMenuMask;
		else if (strcasecmp(value->list.value[i].s, "popupmenu") == 0)
			mask |= CompWindowTypePopupMenuMask;
		else if (strcasecmp(value->list.value[i].s, "tooltip") == 0)
			mask |= CompWindowTypeTooltipMask;
		else if (strcasecmp(value->list.value[i].s, "notification") == 0)
			mask |= CompWindowTypeNotificationMask;
		else if (strcasecmp(value->list.value[i].s, "combo") == 0)
			mask |= CompWindowTypeComboMask;
		else if (strcasecmp(value->list.value[i].s, "dnd") == 0)
			mask |= CompWindowTypeDndMask;
		else if (strcasecmp(value->list.value[i].s, "modaldialog") == 0)
			mask |= CompWindowTypeModalDialogMask;
		else if (strcasecmp(value->list.value[i].s, "fullscreen") == 0)
			mask |= CompWindowTypeFullscreenMask;
		else if (strcasecmp(value->list.value[i].s, "unknown") == 0)
			mask |= CompWindowTypeUnknownMask;
	}

	return mask;
}
