/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "JsInliner.h"
#include "SplittableBuffer.h"
#include "BString.h"
#include "StringUtils.h"

void
JsInliner::inlineJavaScript(
	SplittableBuffer const& input,
	SplittableBuffer& output, Content content)
{
	/*
	In case of HTML we just replace </SCRIPT> (case-insensitive) with
	<\/SCRIPT>. The </SCRIPT> can only occur inside a quoted string literal
	or inside a comment. Fortunately, even single-quoted literals in
	javascript can have escapes. Modifying a comment won't hurt either.
	In case of XHTML, we additionally enclose the script content with
	"//<![CDATA[" and "//]]>".
	And no, just enclosing a script with <!-- and --> won't solve
	our problem, especially when dealing with XHTML.
	
	Another problem is people putting <!-- and --> even to scripts
	stored in files.  That usually doesn't cause troubles,
	but if the closing comment is missing or broken, it confuses
	the html parser.
	*/
	
	if (content == XHTML) {
		output.append(BString("//<![CDATA[\r\n"));
		escapeScriptCloseTag(input, output);
		output.append(BString("\r\n//]]>"));
	} else {
		escapeScriptCloseTag(input, output);
		ensureSgmlCommentClosed(output);
	}
}

void
JsInliner::escapeScriptCloseTag(
	SplittableBuffer const& input,
	SplittableBuffer& output)
{
	BString const subject("</script>");
	BString const insertion("\\");
	SplittableBuffer::ByteIterator base(input.begin());
	SplittableBuffer::ByteIterator const end(input.end());
	SplittableBuffer::ByteIterator pos(base);
	while (true) {
		pos = input.ciFind(pos, end, subject);
		if (pos == end) {
			break;
		}
		++pos; // skip the leading '<'
		output.append(base, pos);
		output.append(insertion);
		base = pos;
		pos += subject.size() - 1; // compensate for ++pos 
	}
	output.append(base, end);
}

void
JsInliner::ensureSgmlCommentClosed(SplittableBuffer& text)
{
#if 0
	BString const comm_begin("<!--");
	BString const comm_end("-->");
	SplittableBuffer::ByteIterator begin(text.begin());
	SplittableBuffer::ByteIterator end(text.end());
	
	if (text.find(comm_begin).isAtRightBorder()) {
		return;
	}
	
	end = StringUtils::rtrim(begin, end);
	if (StringUtils::endsWith(
	     begin, end, comm_end.begin(), comm_end.end())) {
		return;
	}
#endif
	text.append(BString("\r\n// added by BFilter -->"));
}
