/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NfaConcatenation.h"

NfaConcatenation::NfaConcatenation(Nfa const& first)
:	m_length(first.length()),
	m_startPos(first.getStartPos()),
	m_finishPos(first.getFinishPos())
{
	m_states.assign(first.statesBegin(), first.statesEnd());
}

NfaConcatenation::NfaConcatenation(Nfa const& first, Nfa const& second)
:	m_length(first.length()),
	m_startPos(first.getStartPos()),
	m_finishPos(first.getFinishPos())
{
	m_states.assign(first.statesBegin(), first.statesEnd());
	addComponent(second);
}

NfaConcatenation&
NfaConcatenation::addComponent(Nfa const& component)
{
	m_states[m_finishPos].addEpsilonTransition(component.getStartPos()+m_states.size()-m_finishPos);
	m_finishPos = component.getFinishPos()+m_states.size();
	m_states.insert(m_states.end(), component.statesBegin(), component.statesEnd());
	if (m_length == -1 || component.length() == -1) {
		m_length = -1;
	} else {
		m_length += component.length();
	}
	return *this;
}

NfaConcatenation::~NfaConcatenation()
{
}

int
NfaConcatenation::length() const
{
	return m_length;
}

NfaState const*
NfaConcatenation::statesBegin() const
{
	return &m_states[0];
}

NfaState const*
NfaConcatenation::statesEnd() const
{
	return &m_states[m_states.size()];
}

int
NfaConcatenation::getStartPos() const
{
	return m_startPos;
}

int
NfaConcatenation::getFinishPos() const
{
	return m_finishPos;
}
