/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef AVAILABLECONTENTFILTERS_H_
#define AVAILABLECONTENTFILTERS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IntrusivePtr.h"
#include <vector>

class RegexFilterDescriptor;
class ContentFilterList;

/**
 * \brief A collection of valid and enabled content filters.
 *
 * The stored filters are immutable and can be used in concurrent threads
 * without synchronization.
 */
class AvailableContentFilters
{
public:
	typedef IntrusivePtr<RegexFilterDescriptor const> FilterConstPtr;
	typedef std::vector<FilterConstPtr>::const_iterator iterator;
	typedef std::vector<FilterConstPtr>::const_iterator const_iterator;
	
	AvailableContentFilters();
	
	AvailableContentFilters(AvailableContentFilters const& other);
	
	~AvailableContentFilters();
	
	AvailableContentFilters& operator=(AvailableContentFilters const& rhs);
	
	void swap(AvailableContentFilters& other); // throw()
	
	iterator begin() const { return m_filters.begin(); }
	
	iterator end() const { return m_filters.end(); }
	
	/**
	 * \brief Add more filters.
	 *
	 * Filters in ContentFiltersList don't have to be valid or enabled.
	 * We skip those that aren't.  The order of filters in
	 * ContentFilterList must be the same as they appear in a file.
	 */
	void add(ContentFilterList const& filters);
private:
	std::vector<FilterConstPtr> m_filters;
};


inline void swap(AvailableContentFilters& lhs, AvailableContentFilters& rhs)
{
	lhs.swap(rhs);
}

#endif
