/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "State.h"
#include "Conf.h"
#include "Forwarding.h"
#include "UrlPatterns.h"
#include "CombinedUrlPatterns.h"
#include "AvailableFiltersOrdered.h"
#include "FileVersion.h"

class State::Impl
{
public:
	Impl();
	
	~Impl();
	
	Config config;
	Forwarding::Resolver forwardingResolver;
	CombinedUrlPatterns urlPatterns;
	AvailableFiltersOrdered contentFilters;
	FileVersion configFileVersion;
	FileVersion urlsLocalFileVersion;
	bool isFilteringEnabled;
};

State::Impl::Impl()
:	isFilteringEnabled(true)
{
}

State::Impl::~Impl()
{
}


/*================================ State ===============================*/

State::State()
:	m_ptrImpl(new Impl)
{
}

State::~State()
{
}

Config const&
State::config() const
{
	return m_ptrImpl->config;
}

void
State::setConfig(Config const& config)
{
	m_ptrImpl->config = config;
}

void
State::swapConfig(Config& config)
{
	m_ptrImpl->config.swap(config);
}

Forwarding::Resolver&
State::forwardingResolver()
{
	return m_ptrImpl->forwardingResolver;
}

Forwarding::Resolver const&
State::forwardingResolver() const
{
	return m_ptrImpl->forwardingResolver;
}

void
State::swapForwardingResolver(Forwarding::Resolver& resolver)
{
	m_ptrImpl->forwardingResolver.swap(resolver);
}

CombinedUrlPatterns const&
State::urlPatterns() const
{
	return m_ptrImpl->urlPatterns;
}

void
State::setStandardUrlPatterns(UrlPatterns const& patterns)
{
	m_ptrImpl->urlPatterns.standardPatterns() = patterns;
}

void
State::swapStandardUrlPatterns(UrlPatterns& patterns)
{
	m_ptrImpl->urlPatterns.standardPatterns().swap(patterns);
}

void
State::setLocalUrlPatterns(UrlPatterns const& patterns)
{
	m_ptrImpl->urlPatterns.localPatterns() = patterns;
}

void
State::swapLocalUrlPatterns(UrlPatterns& patterns)
{
	m_ptrImpl->urlPatterns.localPatterns().swap(patterns);
}

AvailableFiltersOrdered const&
State::contentFilters() const
{
	return m_ptrImpl->contentFilters;
}

void
State::setContentFilters(AvailableFiltersOrdered const& filters)
{
	m_ptrImpl->contentFilters = filters;
}

void
State::swapContentFilters(AvailableFiltersOrdered& filters)
{
	m_ptrImpl->contentFilters.swap(filters);
}

bool
State::isFilteringEnabled() const
{
	return m_ptrImpl->isFilteringEnabled;
}

void
State::setFilteringEnabled(bool val)
{
	m_ptrImpl->isFilteringEnabled = val;
}

FileVersion
State::getConfigFileVersion() const
{
	return m_ptrImpl->configFileVersion;
}

void
State::setConfigFileVersion(FileVersion const& version)
{
	m_ptrImpl->configFileVersion = version;
}

FileVersion
State::getUrlsLocalFileVersion() const
{
	return m_ptrImpl->urlsLocalFileVersion;
}

void
State::setUrlsLocalFileVersion(FileVersion const& version)
{
	m_ptrImpl->urlsLocalFileVersion = version;
}
