/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DAEMON_H_
#define DAEMON_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "WorkerThreadPool.h"
#include <string>

class ACE_FILE_IO;

class Daemon
{
public:
	bool init(std::string const& confdir);
	
	bool run(bool nodaemon, ACE_FILE_IO& pid_file);
	
	static int killRunning(ACE_FILE_IO& pid_file);
	
	static void initResolver();
	
	static std::string normalizePath(std::string const& path);
	
	class Reconfigurer;
private:
	class ScopeSetEUID;
	class ScopeSetEGID;
	class ConfigErrorHandler;
	class ConfigLoader;
	class ForwardingConfigLoader;
	class UrlPatternsLoader;
	class ContentFiltersLoader;
	
	bool loadConfiguration(std::string const& confdir);
	
	bool bind();
	
	static void sigtermHandler(int signum);
	
	static void sigintHandler(int signum);
	
	static volatile bool m_sSigtermReceived;
	static volatile bool m_sSigintReceived;
	WorkerThreadPool m_workerPool;
};

#endif
