/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef REQUESTLOGWINDOW_H_
#define REQUESTLOGWINDOW_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtkmm/window.h>
#include <memory>

namespace Gtk
{
	class MenuBar;
	class TreeView;
	class ToggleButton;
}

namespace GtkGUI
{

class RequestLogWindow : public Gtk::Window
{
private:
	RequestLogWindow();
public:
	virtual ~RequestLogWindow();
	
	static void showWindow();
private:
	class LegendModel;
	class LogView;
	
	virtual void on_hide();
	
	virtual bool on_key_press_event(GdkEventKey* evt);
	
	void onClear();
	
	void onLegend();
	
	void showLegend();
	
	static RequestLogWindow* m_spInstance;
	Gtk::TreeView* m_pTreeView;
	Gtk::ToggleButton* m_pLegendButton;
};

} // namespace GtkGUI

#endif
