/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ErrorWrapper.h"
#include "ImmediateResponse.h"
#include "ErrorDescriptor.h"
#include "AbstractResponseHandler.h"
#include "RequestPtr.h"

class ErrorWrapper::Response : public ImmediateResponse
{
public:
	Response(std::auto_ptr<ErrorDescriptor> edesc);
	
	virtual ~Response();
	
	virtual void output(
		AbstractResponseHandler& handler,
		ConstRequestPtr const& request,
		RequestStatus& request_status,
		RequestTag const& request_tag);
private:
	std::auto_ptr<ErrorDescriptor> m_ptrErrDesc;
};


std::auto_ptr<ImmediateResponse>
ErrorWrapper::wrap(std::auto_ptr<ErrorDescriptor> edesc)
{
	return std::auto_ptr<ImmediateResponse>(new Response(edesc));
}


/*====================== ErrorWrapper::Response ==========================*/

ErrorWrapper::Response::Response(std::auto_ptr<ErrorDescriptor> edesc)
:	m_ptrErrDesc(edesc)
{
}

ErrorWrapper::Response::~Response()
{
}

void
ErrorWrapper::Response::output(
	AbstractResponseHandler& handler,
	ConstRequestPtr const&,
	RequestStatus& status, RequestTag const&)
{
	handler.processError(status, m_ptrErrDesc);
}
