/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "WebbugAdSuspect.h"
#include "HtmlEscaper.h"
#include "BString.h"
#include <ostream>
#include <algorithm>

using namespace std;

WebbugAdSuspect::~WebbugAdSuspect()
{
}

int
WebbugAdSuspect::getWidth() const
{
	return 1;
}

int
WebbugAdSuspect::getHeight() const
{
	return 1;
}

URI const&
WebbugAdSuspect::getLocation() const
{
	return m_location;
}

bool
WebbugAdSuspect::isLocationAbsolute() const
{
	return m_isLocationAbsolute;
}

HeuristicScore const&
WebbugAdSuspect::getScore() const
{
	return m_score;
}

BString
WebbugAdSuspect::getSubstitutionURL() const
{
	return getSubstitutionURL(m_location);
}

void
WebbugAdSuspect::writeSubstitution(ostream& strm) const
{
	strm << "<img alt=\"Ad replacement [webbug]\" border=\"0\""
		" width=\"1\" height=\"1\" src=\""
		<< HtmlEscaper::escape(getSubstitutionURL()) << "\" /></a>";
}
