/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ETag.h"
#include "InsensitiveEqual.h"
#include <boost/test/auto_unit_test.hpp>
#include <string>

BOOST_AUTO_UNIT_TEST(test)
{
	ETag const s123("\"123\"");
	ETag const s123_2(s123);
	ETag const w123("W/\"123\"");
	ETag const w123_2("w/\"123\"");
	ETag const s321("\"321\"");
	ETag const w321("W/\"321\"");
	
	BOOST_REQUIRE(s123.isValid());
	BOOST_REQUIRE(w123.isValid());
	BOOST_REQUIRE(!s123.isWeak());
	BOOST_REQUIRE(w123.isWeak());
	BOOST_REQUIRE(!ETag().isValid());
	BOOST_REQUIRE(!ETag("").isValid());
	BOOST_REQUIRE(!ETag("non-quoted").isValid());
	BOOST_REQUIRE(!ETag("W/invalid\"").isValid());
	
	InsensitiveEqual ieq;
	BOOST_CHECK(ieq(ETag("\"123\"").toBString(), BString("\"123\"")));
	BOOST_CHECK(ieq(ETag("w/\"123\"").toBString(), BString("w/\"123\"")));
	
	BOOST_CHECK(s123.strongIdentity(s123_2));
	BOOST_CHECK(!s123.strongIdentity(s321));
	BOOST_CHECK(!s123.weakIdentity(s321));
	BOOST_CHECK(w123.weakIdentity(w123_2));
	BOOST_CHECK(!w123.strongIdentity(w123_2));
	BOOST_CHECK(!w123.weakIdentity(w321));
	BOOST_CHECK(!w123.weakIdentity(ETag("invalid")));
}
