/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef INSENSITIVEEQUAL_H_
#define INSENSITIVEEQUAL_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "StringUtils.h"
#include "BString.h"
#include <string>

class InsensitiveEqual
{
public:
	InsensitiveEqual() {}
	
	bool operator()(std::string const& lhs, std::string const& rhs) const {
		return StringUtils::ciEqual(lhs, rhs);
	}
	
	bool operator()(char const* lhs, char const* rhs) const {
		return StringUtils::ciEqual(lhs, rhs);
	}
	
	bool operator()(std::string const& lhs, char const* rhs) const {
		return StringUtils::ciEqual(lhs.c_str(), rhs);
	}
	
	bool operator()(char const* lhs, std::string const& rhs) const {
		return StringUtils::ciEqual(lhs, rhs.c_str());
	}
	
	bool operator()(BString const& lhs, BString const& rhs) const {
		return StringUtils::ciEqual(lhs.begin(), lhs.end(), rhs.begin(), rhs.end());
	}
};

#endif
