/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SHA1_H
#define SHA1_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HashValue.h"
#include "types.h"
#include <stddef.h>

class SHA1
{
public:
	enum { HASH_SIZE = 20 };
	
	typedef HashValue<HASH_SIZE> Value;
	
	SHA1();
	
	// Member-wise copying is OK
	
	void feed(uint8_t const* data, size_t len);
	
	void finalize(Value& output);
	
	void reset();
private:
	enum { BLOCK_SIZE = 64 };
	
	void transform(uint8_t const* data);
	
	uint64_t m_inputSize;
	uint8_t m_buf[BLOCK_SIZE];
	int m_bufPos;
	uint32_t m_state[5];
};

#endif
