/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef FILTERGROUPFLAGS_H_
#define FILTERGROUPFLAGS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FilterGroupTag.h"
#include <string>
#include <set>

class FilterGroupFlags
{
public:
	// Member-wise copying is OK.
	
	void set(FilterGroupTag const& group, std::string const& name);
	
	void clear(FilterGroupTag const& group, std::string const& name);
	
	bool isSet(FilterGroupTag const& group, std::string const& name) const;
private:
	struct Item
	{
		FilterGroupTag group;
		std::string name;
		
		Item(FilterGroupTag const& grp, std::string const& nam)
		: group(grp), name(nam) {}
		
		bool operator<(Item const& rhs) const;
	};
	
	std::set<Item> m_items;
};

#endif
