/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTMLNODEWITHOUTATTRIBUTES_H_
#define HTMLNODEWITHOUTATTRIBUTES_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HtmlNode.h"
#include "BString.h"

class HtmlNodeWithoutAttributes : virtual public HtmlNode
{
public:
	virtual BString const& getTagName() const;
	
	virtual void setTagName(BString const& name);
	
	virtual int getTagType() const;
	
	virtual void setTagType(int type);
	
	virtual bool isClosed() const;
	
	virtual void setClosed(bool closed);
	
	virtual bool hasAdMark() const;
	
	virtual void setAdMark(bool mark);
	
	virtual AttributeMap const& getRawAttributes() const;
	
	virtual bool hasAttribute(BString const& name) const;
	
	virtual bool isBooleanAttribute(BString const& name) const;
	
	virtual BString getRawAttribute(BString const& name) const;
	
	virtual BString getAttribute(BString const& name) const;
	
	virtual void setRawAttribute(BString const& name, BString const& value);
	
	virtual void setAttribute(BString const& name, BString const& value);
	
	virtual void setBooleanAttribute(BString const& name);
	
	virtual void removeAttribute(BString const& name);
private:
	static BString const m_sEmptyString;
	static AttributeMap const m_sEmptyAttributes;
};

#endif
