/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpHeader.h"
#include "DataChunk.h"
#include <ostream>
#include <memory>
#include <cstring>
#include <stddef.h>

using namespace std;

HttpHeader::HttpHeader(BString const& name, BString const& value)
:	m_name(name)
{
	m_values.push_back(value);
}

HttpHeader::~HttpHeader()
{
}

BString
HttpHeader::getValue() const
{
	BString res;
	list<BString>::const_iterator it = m_values.begin();
	list<BString>::const_iterator const end = m_values.end();
	if (it == end) {
		return res; // no elements
	}
	res = *it;
	++it;
	if (it == end) {
		return res; // one element
	}
	size_t len = res.size();
	for (; it != end; ++it) {
		len += 2 + it->size();
		// 2 is for the ", " separator
	}
	auto_ptr<DataChunk> chunk(DataChunk::create(len));
	char* p = chunk->getDataAddr();
	it = m_values.begin();
	memcpy(p, it->begin(), it->size());
	p += it->size();
	++it;
	for (; it != end; ++it) {
		*p++ = ',';
		*p++ = ' ';
		memcpy(p, it->begin(), it->size());
		p += it->size();
	}
	return BString(chunk);
}

void
HttpHeader::setValue(BString const& value)
{
	m_values.clear();
	m_values.push_back(value);
}

void
HttpHeader::toStream(std::ostream& strm) const
{
	list<BString>::const_iterator it = m_values.begin();
	list<BString>::const_iterator const end = m_values.end();
	for (; it != end; ++it) {
		strm << m_name << ": " << *it << "\r\n";
	}
}

bool operator==(HttpHeader const& h1, HttpHeader const& h2)
{
	return h1.getName() == h2.getName() && h1.getValues() == h2.getValues();
}
