/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpVersion.h"
#include "StringUtils.h"
#include <cstring>

using namespace std;

HttpVersion const HttpVersion::HTTP_0_9(0, 9);
HttpVersion const HttpVersion::HTTP_1_0(1, 0);
HttpVersion const HttpVersion::HTTP_1_1(1, 1);

void
HttpVersion::toStream(std::ostream& strm) const
{
	strm << "HTTP/" << m_major << '.' << m_minor;
}

bool
HttpVersion::parse(char const* begin, char const* end)
{
	if (end - begin < 8 || memcmp(begin, "HTTP/", 5)) {
		return false;
	}
	begin += 5;
	char const* const dot_pos = StringUtils::find(begin, end, '.');
	char const* num_end = dot_pos;
	int major = StringUtils::parseUnsigned<int>(begin, num_end);
	if (num_end != dot_pos || num_end == begin) {
		return false;
	}
	num_end = end;
	int minor = StringUtils::parseUnsigned<int>(dot_pos+1, num_end);
	if (num_end != end || num_end == dot_pos+1) {
		return false;
	}
	m_major = major;
	m_minor = minor;
	return true;
}

bool
HttpVersion::operator<(const HttpVersion& other) const
{
	if (m_major < other.m_major) {
		return true;
	} else if (m_major > other.m_major) {
		return false;
	} else {
		return (m_minor < other.m_minor);
	}
}

bool
HttpVersion::operator>(const HttpVersion& other) const
{
	if (m_major > other.m_major) {
		return true;
	} else if (m_major < other.m_major) {
		return false;
	} else {
		return (m_minor > other.m_minor);
	}
}
