/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SOCKSASYNCCONNECTOR_H_
#define SOCKSASYNCCONNECTOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "Socks4AsyncConnector.h"
#include "Socks5AsyncConnector.h"
#include "AutoClosingSAP.h"
#include <string>

class ACE_SOCK_Stream;
class InetAddr;
class SymbolicInetAddr;
class Reactor;
class TimeDelta;
class SocksError;
class SocksConnectorListener;

class SocksAsyncConnector
{
	DECLARE_NON_COPYABLE(SocksAsyncConnector)
public:
	enum SocksType { SOCKS4, SOCKS4A, SOCKS5 };
	
	typedef SocksConnectorListener Listener;
	
	SocksAsyncConnector();
	
	~SocksAsyncConnector();
	
	bool isInProgress() const;
	
	void initiate(SocksType socks_type, Listener& listener, Reactor& reactor,
		AutoClosingSAP<ACE_SOCK_Stream>& proxy_conn,
		SymbolicInetAddr const& target_addr,
		std::string const& username, std::string const& password,
		TimeDelta const* timeout = 0);
	
	void abort();
private:
	Socks4AsyncConnector m_socks4Connector;
	Socks5AsyncConnector m_socks5Connector;
};

#endif
