/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "WebbugHeuristicScore.h"
#include "URI.h"

using namespace std;

int
WebbugHeuristicScore::getNumericScore() const
{
	return m_score;
}

int
WebbugHeuristicScore::getNumericSizeScore() const
{
	return 0;
}

void
WebbugHeuristicScore::processImageUrl(URI const& abs, URI const& rel, URI const& base)
{
	m_score += getHintModifier(abs);
	UrlRelationship rship = getUrlRelationship(rel, base);
	if (rship == URLS_UNRELATED) {
		m_score += 150;
	} else if (rship == URLS_SAME_HOST) {
		m_score -= 20;
	}
	UrlFlags const flags = getUrlStatus(abs, EXPECT_IMAGE);
	if (flags & LOOKS_LIKE_SCRIPT) {
		m_score += 150;
	} else {
		m_score -= 60;
	}
}

void
WebbugHeuristicScore::processNoscript(bool val)
{
	if (val) {
		m_score += 40;
	}
}

void
WebbugHeuristicScore::processScriptLevel(int level, bool external)
{
	if (level > 1) {
		m_score += 150;
	} else if (level > 0) {
		m_score += 90;
		if (external) {
			m_score += 60;
		}
	}
	
}

void
WebbugHeuristicScore::processScriptRedirect(bool val)
{
	if (val) {
		m_score += 60;
	}
}

void
WebbugHeuristicScore::processScriptPersistentCookies(bool val)
{
	if (val) {
		m_score += 60;
	}
}
