/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "MemoryReader.h"
#include "HttpResponseMetadata.h"
#include <algorithm>
#include <string.h>

namespace HttpCache
{

MemoryReader::MemoryReader(
	std::auto_ptr<HttpResponseMetadata> metadata, BString const& body)
:	m_ptrMetadata(metadata),
	m_bodyData(body)
{
}

MemoryReader::~MemoryReader()
{
}

std::auto_ptr<HttpResponseMetadata>
MemoryReader::retrieveMetadata()
{
	return m_ptrMetadata;
}

ssize_t
MemoryReader::readBodyData(void* const buf, size_t const len)
{
	size_t const todo = std::min(len, m_bodyData.size());
	memcpy(buf, m_bodyData.begin(), todo);
	m_bodyData.trimFront(todo);
	return todo;
}

} // namespace HttpCache
