/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AboutDialog.h"
#include "Application.h"
#include "CompiledImages.h"
#include <gtkmm/box.h>
#include <gtkmm/alignment.h>
#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtkmm/stock.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <pangomm/fontdescription.h>
#include <cassert>

using namespace std;

namespace GtkGUI
{

AboutDialog* AboutDialog::m_spInstance = 0;

AboutDialog::AboutDialog()
{
	set_title("About BFilter");
	set_icon(CompiledImages::window_icon_png.getPixbuf());
	set_has_separator(false);
	
	Gtk::Alignment* main_align = manage(new Gtk::Alignment(0.5, 0.0, 0.0, 0.0));
	get_vbox()->pack_start(*main_align);
	
	Gtk::VBox* vbox = manage(new Gtk::VBox);
	main_align->add(*vbox);
	vbox->set_spacing(5);
	
	Gtk::Image* logo = manage(new Gtk::Image(CompiledImages::logo_png.getPixbuf()));
	vbox->pack_start(*logo);
	
	Gtk::Label* caption = manage(new Gtk::Label("BFilter " BFILTER_VERSION));
	vbox->pack_start(*caption);
	Pango::FontDescription caption_font;
	caption_font.set_size(17 * Pango::SCALE);
	caption_font.set_weight(Pango::WEIGHT_BOLD);
	caption->modify_font(caption_font);
	
	Gtk::Label* subcaption = manage(
		new Gtk::Label("A web proxy aimed at removing banner ads.")
	);
	vbox->pack_start(*subcaption);
	Pango::FontDescription subcaption_font;
	subcaption_font.set_size(14 * Pango::SCALE);
	subcaption->modify_font(subcaption_font);
	
	Gtk::Label* url = manage(new Gtk::Label("http://bfilter.sourceforge.net"));
	vbox->pack_start(*url);
	url->set_selectable(true);
	Pango::FontDescription url_font;
	url_font.set_size(12 * Pango::SCALE);
	url->modify_font(url_font);
	
	get_action_area()->set_layout(Gtk::BUTTONBOX_DEFAULT_STYLE);
	add_button(Gtk::Stock::CLOSE, Gtk::RESPONSE_CLOSE);
	
	signal_response().connect(sigc::hide(sigc::mem_fun(*this, &AboutDialog::hide)));
	
	show_all_children();
	
	Application::instance()->destroySignal().connect(
		sigc::mem_fun(*this, &AboutDialog::hide)
	);
}

AboutDialog::~AboutDialog()
{
	assert(m_spInstance);
	m_spInstance = 0;
}

void
AboutDialog::showWindow()
{
	if (m_spInstance) {
		m_spInstance->present();
	} else {
		(m_spInstance = new AboutDialog)->show();
	}
}

void
AboutDialog::on_hide()
{
	delete this;
}

} // namespace GtkGUI
