/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef FILTERCONFIGWINDOW_H_
#define FILTERCONFIGWINDOW_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractLogView.h"
#include <gtkmm/window.h>
#include <glibmm/refptr.h>
#include <string>
#include <memory>

class FilterGroupTag;
class LogWidget;
namespace Gtk {
	class TextView;
	class TreeIter;
	class TreeRow;
	class MenuBar;
}
namespace Gdk {
	class Pixbuf;
}
namespace Glib {
	class ustring;
}

namespace GtkGUI
{

class FilterConfigWindow : public Gtk::Window, private AbstractLogView
{
private:
	FilterConfigWindow();
public:
	virtual ~FilterConfigWindow();
	
	static bool isFilterGroupBeingEdited(FilterGroupTag const& group_tag);
	
	static void showWindow();
private:
	struct EditState;
	class MyCellRendererToggle;
	class RadioButtonEx;
	class EntryEx;
	class TextBufferEx;
	class FilterTree;
	struct FilterTreeColumns;
	class FilterTreeModel;
	class FileNode;
	class FilterNode;
	class FilterPanel;
	class NoItemContextMenu;
	class FileContextMenu;
	class FilterContextMenu;
	friend class FilterConfigWindow::FilterTree;
	friend class FilterConfigWindow::FilterPanel;
	
	enum Operation { CREATING, EDITING };
	enum CheckState { UNCHECKED, CHECKED, MIXED };
	
	std::auto_ptr<Gtk::MenuBar> createMenuBar();
	
	virtual void on_hide();
	
	virtual bool on_delete_event(GdkEventAny*);
	
	bool prepareForWindowDestruction();
	
	FilterTreeColumns const& getCols() const;
	
	bool onFocusChange(GdkEventFocus*);
	
	void onClearLog();
	
	void onReset();
	
	void onSave();
	
	void markCurrentFilterAsModified();
	
	void handleItemNewName(
		Gtk::TreeIter const& item, Glib::ustring const& new_name);
	
	bool createFile(
		Gtk::TreeRow& row, Glib::ustring const& name);
	
	bool doCreateFile(Gtk::TreeRow& row,
		Glib::ustring const& name, std::string const& fname);
	
	bool doCloneFile(Gtk::TreeRow& row,
		Glib::ustring const& name, std::string const& fname);
	
	bool renameFile(
		Gtk::TreeRow& row, Glib::ustring const& new_name);
	
	bool createFilter(Gtk::TreeRow const& row,
		Gtk::TreeRow& parent_row, Glib::ustring const& name);
	
	bool renameFilter(Gtk::TreeRow const& row,
		Gtk::TreeRow& parent_row, Glib::ustring const& new_name);
	
	bool verifyFileNameValid(Glib::ustring const& name);
	
	bool verifyFileNameLocaleConvertable(
		Glib::ustring const& name, std::string* result = 0);
	
	bool verifyFileDoesntExist(std::string const& fname);
	
	bool verifyFilterNameValid(Glib::ustring const& name);
	
	bool verifyFilterNameLocaleConvertable(
		Glib::ustring const& name, std::string* result = 0);
	
	bool verifyFilterDoesntExist(
		Gtk::TreeRow const& parent_row, Glib::ustring const& name);
	
	void onItemUnselected(Gtk::TreeIter const& item);
	
	void onItemSelected(Gtk::TreeIter const& item);
	
	void onNewFile();
	
	void onReload();
	
	void showError(Glib::ustring const& msg, bool markup = false);
	
	static Glib::RefPtr<Gdk::Pixbuf> getFileIcon();
	
	static Glib::RefPtr<Gdk::Pixbuf> getFilterIcon();
	
	static FilterConfigWindow* m_spInstance;
	Glib::RefPtr<FilterTreeModel> m_ptrFilterTreeModel;
	FilterTree* m_pFilterTree;
	FilterPanel* m_pFilterPanel;
	Gtk::TextView* m_pLogView;
};

} // namespace GtkGUI

#endif
