/*
Copyright 2010, 2012, 2014 Jose Robson Mariano Alves

This file is part of bgfinancas.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*/

package Biblioteca;

public class Database {
    
    private Database(){ }
    
    public static void GerarBanco(){
        Conexao Banco = Conexao.getInstance();
        Banco.executeUpdate("CREATE TABLE agenda (\n" +
                            "  id_agenda INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  id_tipo INTEGER, \n" +
                            "  descricao VARCHAR_IGNORECASE(100), \n" +
                            "  valor DECIMAL(10,2), \n" +
                            "  data DATE)");
        Banco.executeUpdate("CREATE TABLE agenda_tipos (\n" +
                            "  id_tipo INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  nome VARCHAR_IGNORECASE(100))");
        Banco.executeUpdate("CREATE TABLE contas (\n" +
                            "  id_conta INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  nome VARCHAR_IGNORECASE(100), \n" +
                            "  valor DECIMAL(10,2), \n" +
                            "  ativada INTEGER, \n" +
                            "  saldo_total VARCHAR_IGNORECASE(10))");
        Banco.executeUpdate("CREATE TABLE despesas (\n" +
                            "  id_despesa INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  id_conta INTEGER, \n" +
                            "  id_item INTEGER, \n" +
                            "  quantidade DECIMAL(10,2), \n" +
                            "  valor DECIMAL(10,2), \n" +
                            "  data DATE, \n" +
                            "  hora TIME)");
        Banco.executeUpdate("CREATE TABLE despesas_categorias (\n" +
                            "  id_categoria INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  nome VARCHAR_IGNORECASE(100))");
        Banco.executeUpdate("CREATE TABLE despesas_itens (\n" +
                            "  id_item INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  id_categoria INTEGER, \n" +
                            "  nome VARCHAR_IGNORECASE(100))");
        Banco.executeUpdate("CREATE TABLE planejamento (\n" +
                            "  id_planejamento INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  mes INTEGER, \n" +
                            "  ano INTEGER, \n" +
                            "  valor DECIMAL(10,2))");
        Banco.executeUpdate("CREATE TABLE planejamento_componentes (\n" +
                            "  id_planejamento INTEGER, \n" +
                            "  id_item INTEGER, \n" +
                            "  valor DECIMAL(10,2))");
        Banco.executeUpdate("CREATE TABLE planejamento_itens (\n" +
                            "  id_item INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  nome VARCHAR_IGNORECASE(100))");
        Banco.executeUpdate("CREATE TABLE receitas (\n" +
                            "  id_receita INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  id_conta INTEGER, \n" +
                            "  id_item INTEGER, \n" +
                            "  descricao VARCHAR_IGNORECASE(100), \n" +
                            "  valor DECIMAL(10,2), \n" +
                            "  data DATE, \n" +
                            "  hora TIME)");
        Banco.executeUpdate("CREATE TABLE receitas_categorias (\n" +
                            "  id_categoria INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  nome VARCHAR_IGNORECASE(100))");
        Banco.executeUpdate("CREATE TABLE receitas_itens (\n" +
                            "  id_item INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  id_categoria INTEGER, \n" +
                            "  nome VARCHAR_IGNORECASE(100))");
        Banco.executeUpdate("CREATE TABLE relatorios_grupos (\n" +
                            "  id_relatorios_grupos INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  nome VARCHAR_IGNORECASE(100), \n" +
                            "  valor DECIMAL(10,2), \n" +
                            "  saldo_total VARCHAR_IGNORECASE(10))");
        Banco.executeUpdate("CREATE TABLE relatorios_grupos_itens (\n" +
                            "  id_relatorios_grupos INTEGER, \n" +
                            "  id_despesas_categorias INTEGER)");
        Banco.executeUpdate("CREATE TABLE transferencias (\n" +
                            "  id_transferencia INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  id_conta1 INTEGER, \n" +
                            "  id_conta2 INTEGER, \n" +
                            "  id_item INTEGER, \n" +
                            "  descricao VARCHAR_IGNORECASE(100), \n" +
                            "  valor DECIMAL(10,2), \n" +
                            "  data DATE, \n" +
                            "  hora TIME)");
        Banco.executeUpdate("CREATE TABLE transferencias_categorias (\n" +
                            "  id_categoria INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  nome VARCHAR_IGNORECASE(100))");
        Banco.executeUpdate("CREATE TABLE transferencias_itens (\n" +
                            "  id_item INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  id_categoria INTEGER, \n" +
                            "  nome VARCHAR_IGNORECASE(100))");
        Banco.executeUpdate("CREATE TABLE usuarios (\n" +
                            "  id_usuarios INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, \n" +
                            "  nome VARCHAR_IGNORECASE(100), \n" +
                            "  usuario VARCHAR_IGNORECASE(100), \n" +
                            "  senha VARCHAR_IGNORECASE(100))");
    }
}
