/*
Copyright 2010, 2012, 2014 Jose Robson Mariano Alves

This file is part of bgfinancas.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*/

package Utilitarios;

import Biblioteca.Botoes;

import Biblioteca.Janela;
import Biblioteca.Janelinha;
import Biblioteca.Secure;
import Biblioteca.Visual;
import Principal.TelaPrincipal;
import java.sql.SQLException;

public final class AlterarSenha extends Janela {

    private final TelaPrincipal Principal;
    private final String Logado;
    
    public AlterarSenha(TelaPrincipal principal) {
        initComponents();
        Visual.Janela(this.getJanela());
        BarraDeFerramentas.add(Botoes.Sair(this));
        Principal = principal;
        Logado = Principal.getLogado();
    }

    public boolean ValidarFormulario()
    {
        if(String.valueOf(senha_atual.getPassword()).equals("")){
            Janelinha.Aviso(Lingua.getMensagem("atencao"), Lingua.getMensagem("campo_nao_informado")+" "+Lingua.getMensagem("senha_atual"));
            senha_atual.requestFocus();
            return false;
        }else{
            Banco.executeQuery("SELECT id_usuarios FROM usuarios WHERE senha='"+Secure.md5(String.valueOf(senha_atual.getPassword()))+"'");
            try {
                if (Banco.getResultSet().next()) {
                    if(String.valueOf(senha1.getPassword()).equals("")){
                        Janelinha.Aviso(Lingua.getMensagem("atencao"), Lingua.getMensagem("campo_nao_informado")+" "+Lingua.getMensagem("senha_nova"));
                        senha1.requestFocus();
                        return false;
                    }else if (String.valueOf(senha1.getPassword()).equals(String.valueOf(senha2.getPassword()))) {
                        return true;
                    } else {
                        Janelinha.Aviso(Lingua.getMensagem("atencao"), Lingua.getMensagem("senhas_diferentes"));
                        return false;
                    }
                } else {
                    Janelinha.Aviso(Lingua.getMensagem("atencao"), Lingua.getMensagem("senha_atual_incorreta"));
                    return false;
                }
            } catch (SQLException ex) {
                Janelinha.Aviso(Lingua.getMensagem("atencao"), Lingua.getMensagem("excecao")+" "+ex);
                return false;
            }
        }
    }
    
    public void Alterar()
    {   
        try{
            Banco.executeQuery("SELECT id_usuarios FROM usuarios WHERE senha='"+Secure.md5(String.valueOf(senha_atual.getPassword()))+"'");
            Banco.getResultSet().next();
            String id_usuario = Banco.getResultSet().getString("id_usuarios");
            Banco.executeUpdate("UPDATE usuarios SET senha='"+Secure.md5(String.valueOf(senha1.getPassword()))+"' WHERE id_usuarios='"+id_usuario+"'");
            Janelinha.Aviso(Lingua.getMensagem("alterar"),Lingua.getMensagem("sucesso"));
            AlterarSenha.this.dispose();
        }catch(SQLException e){
            Janelinha.Aviso(Lingua.getMensagem("erro"),Lingua.getMensagem("excecao")+" "+e);
        }
    }
    
    @Override
    public void Botoes(String acao)
    {
        if(acao.equals(Lingua.getMensagem("sair"))){
            AlterarSenha.this.dispose();
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        BarraDeFerramentas = new javax.swing.JToolBar();
        PanelSenha = new javax.swing.JPanel();
        SENHA = new javax.swing.JLabel();
        BFinalizar = new javax.swing.JButton();
        senha_atual = new javax.swing.JPasswordField();
        SENHA1 = new javax.swing.JLabel();
        senha1 = new javax.swing.JPasswordField();
        SENHA2 = new javax.swing.JLabel();
        senha2 = new javax.swing.JPasswordField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(Lingua.getMensagem("alterar_senha"));
        setFont(new java.awt.Font("Tahoma", 0, 11)); // NOI18N
        setForeground(java.awt.Color.cyan);
        getContentPane().setLayout(null);

        BarraDeFerramentas.setFloatable(false);
        BarraDeFerramentas.setRollover(true);
        getContentPane().add(BarraDeFerramentas);
        BarraDeFerramentas.setBounds(0, 0, 440, 41);

        PanelSenha.setBorder(javax.swing.BorderFactory.createTitledBorder(null, Lingua.getMensagem("dados_usuario")
            , javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, FonteFinancas, new java.awt.Color(0, 102, 204)));
    PanelSenha.setForeground(new java.awt.Color(51, 94, 168));
    PanelSenha.setLayout(null);

    SENHA.setFont(FonteFinancas);
    SENHA.setForeground(new java.awt.Color(51, 94, 168));
    SENHA.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
    SENHA.setText(Lingua.getMensagem("senha_atual")+":");
    SENHA.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
    PanelSenha.add(SENHA);
    SENHA.setBounds(10, 40, 130, 20);

    BFinalizar.setFont(FonteFinancas);
    BFinalizar.setText(Lingua.getMensagem("alterar"));
    BFinalizar.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            BFinalizarActionPerformed(evt);
        }
    });
    PanelSenha.add(BFinalizar);
    BFinalizar.setBounds(150, 130, 120, 20);

    senha_atual.setFont(FonteFinancas);
    PanelSenha.add(senha_atual);
    senha_atual.setBounds(150, 40, 200, 20);

    SENHA1.setFont(FonteFinancas);
    SENHA1.setForeground(new java.awt.Color(51, 94, 168));
    SENHA1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
    SENHA1.setText(Lingua.getMensagem("senha_nova")+":");
    SENHA1.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
    PanelSenha.add(SENHA1);
    SENHA1.setBounds(10, 70, 130, 20);

    senha1.setFont(FonteFinancas);
    PanelSenha.add(senha1);
    senha1.setBounds(150, 70, 200, 20);

    SENHA2.setFont(FonteFinancas);
    SENHA2.setForeground(new java.awt.Color(51, 94, 168));
    SENHA2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
    SENHA2.setText(Lingua.getMensagem("senha_confirmar")+":");
    SENHA2.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
    PanelSenha.add(SENHA2);
    SENHA2.setBounds(10, 100, 130, 20);

    senha2.setFont(FonteFinancas);
    PanelSenha.add(senha2);
    senha2.setBounds(150, 100, 200, 20);

    getContentPane().add(PanelSenha);
    PanelSenha.setBounds(20, 60, 390, 173);

    setSize(new java.awt.Dimension(431, 274));
    setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

private void BFinalizarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_BFinalizarActionPerformed
        if(ValidarFormulario() && Janelinha.Pergunta(Lingua.getMensagem("alterar"),Lingua.getMensagem("tem_certeza")))
        {
            Alterar();
        }
}//GEN-LAST:event_BFinalizarActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton BFinalizar;
    private javax.swing.JToolBar BarraDeFerramentas;
    private javax.swing.JPanel PanelSenha;
    private javax.swing.JLabel SENHA;
    private javax.swing.JLabel SENHA1;
    private javax.swing.JLabel SENHA2;
    private javax.swing.JPasswordField senha1;
    private javax.swing.JPasswordField senha2;
    private javax.swing.JPasswordField senha_atual;
    // End of variables declaration//GEN-END:variables

}
