#ifndef BGLIBS__NET__DNS__H__
#define BGLIBS__NET__DNS__H__

#include <sysdeps.h>
#include <str/str.h>
#include <net/ipv4.h>

#define DNS_RCODE_OK 0
#define DNS_RCODE_FORMAT 1
#define DNS_RCODE_SRVFAIL 2
#define DNS_RCODE_NXDOMAIN 3
#define DNS_RCODE_NOTIMP 4
#define DNS_RCODE_REFUSED 5

#define DNS_CLASS_IN 1

#define DNS_TYPE_A 1
#define DNS_TYPE_MX 15
#define DNS_TYPE_PTR 12
#define DNS_TYPE_TXT 16
#define DNS_TYPE_ANY 255

#define DNS_MAX_LABEL 63
#define DNS_MAX_NAME 255

struct dns_header
{
  unsigned id;
  unsigned qr;
  /* unsigned opcode; -- always zero */
  unsigned aa;
  unsigned tc;
  unsigned rd;
  unsigned ra;
  /* unsigned z; -- always zero */
  unsigned rcode;
  unsigned qdcount;
  unsigned ancount;
  unsigned nscount;
  unsigned arcount;
};

struct dns_packet
{
  struct dns_header hdr;
  str data;
  unsigned an_offset;
};

#include <uint16.h>
#define dns_header_id(P) uint16_get_msb(P)
#define dns_header_qr(P) (((P)[2]>>7)&1)
#define dns_header_opcode(P) (((P)[2]>>3)&0xf)
#define dns_header_aa(P) (((P)[2]>>2)&1)
#define dns_header_tc(P) (((P)[2]>>1)&1)
#define dns_header_rd(P) ((P)[2]&1)
#define dns_header_ra(P) (((P)[3]>>7)&1)
#define dns_header_z(P) (((P)[3]>>4)&7)
#define dns_header_rcode(P) ((P)[3]&0xf)
#define dns_header_qdcount(P) uint16_get_msb((P)+4)
#define dns_header_ancount(P) uint16_get_msb((P)+6)
#define dns_header_nscount(P) uint16_get_msb((P)+8)
#define dns_header_arcount(P) uint16_get_msb((P)+10)
#define dns_header_len 12

/* Standard return value convention:
 * -1 means system or I/O error
 *  0 means either no error or no results
 * >0 means N results
 */

#define DNS_MAX_SERVERS 8
#define DNS_MAX_IPS 16

/* dns/config.c */
extern str dns_search;
extern ipv4addr dns_servers[DNS_MAX_SERVERS];
extern unsigned dns_server_count;
int dns_try_reload_config();
int dns_reload_config();

/* dns/header.c */
void dns_header_pack(const struct dns_header*, uint8[12]);
void dns_header_unpack(const uint8[12], struct dns_header*);

/* dns/init.c */
int dns_init(void);

/* dns/ip.c */
int dns_ipv4(const char* domain, ipv4addr* ips, unsigned maxips);
int dns_ipv4_fqdn(const char* domain, ipv4addr* ips, unsigned maxips);

/* dns/mx.c */
int dns_mx(const char* domain, str* mxs);
int dns_mx_fqdn(const char* domain, str* mxs);

/* dns/name.c */
int dns_dots_to_name(const char* dots, str* name);
int dns_name_to_dots(const uint8* name, unsigned namelen, str* dots);
int dns_uncompress_name(const uint8* name, unsigned namelen, const str* packet,
			str* out);

/* dns/name4.c */
int dns_name4(const ipv4addr* ip, str* name);

/* dns/packet.c */
int dns_packet_get(const str* pkt, str* out, uint16);

/* dns/query.c */
int dns_build_query(const char* domain, const char* suffix,
		    int type, str* packet);
int dns_query(const char* domain, int type, str* packet);
int dns_query_fqdn(const char* domain, int type, str* packet);

/* dns/random.c */
unsigned long dns_random(unsigned long scale);
void dns_random_init(void);

/* dns/transmit.c */
int dns_txrx(str* query, str* response);

#endif
